/*
 * Decompiled with CFR 0.152.
 */
package mrthomas20121.rocksalt;

import java.util.ArrayList;
import mrthomas20121.rocksalt.utils.AnvilUtils;
import net.dries007.tfc.api.recipes.BloomeryRecipe;
import net.dries007.tfc.api.recipes.anvil.AnvilRecipe;
import net.dries007.tfc.api.registries.TFCRegistryEvent;
import net.dries007.tfc.api.types.Metal;
import net.dries007.tfc.api.types.Ore;
import net.dries007.tfc.api.types.Rock;
import net.dries007.tfc.util.fuel.FuelManager;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="rocksalt")
public class RegistryHandler {
    private static ArrayList<Rock> rocks = new ArrayList();
    private static ArrayList<Ore> ores = new ArrayList();
    private static ArrayList<Metal> metals = new ArrayList();

    public static void addRock(Rock rock) {
        rocks.add(rock);
    }

    public static ArrayList<Rock> getRocks() {
        return rocks;
    }

    public static void addOre(Ore ore) {
        ores.add(ore);
    }

    public static ArrayList<Ore> getOres() {
        return ores;
    }

    public static void addMetal(Metal metal) {
        metals.add(metal);
    }

    public static ArrayList<Metal> getMetals() {
        return metals;
    }

    @SubscribeEvent
    public static void onPreRegisterMetal(TFCRegistryEvent.RegisterPreBlock<Metal> event) {
        IForgeRegistry r = event.getRegistry();
        for (Metal metal : RegistryHandler.getMetals()) {
            r.register((IForgeRegistryEntry)metal);
        }
    }

    @SubscribeEvent
    public static void onPreRegisterRock(TFCRegistryEvent.RegisterPreBlock<Rock> event) {
        IForgeRegistry r = event.getRegistry();
        for (Rock rock : RegistryHandler.getRocks()) {
            r.register((IForgeRegistryEntry)rock);
        }
    }

    @SubscribeEvent
    public static void onRegisterAnvilRecipeEvent(RegistryEvent.Register<AnvilRecipe> event) {
        IForgeRegistry r = event.getRegistry();
        for (Metal metal : RegistryHandler.getMetals()) {
            if (metal.getTier() != Metal.Tier.TIER_III) continue;
            r.register((IForgeRegistryEntry)AnvilUtils.createBloomRecipe(metal));
        }
    }

    @SubscribeEvent
    public static void onRegisterBloomeryRecipeEvent(RegistryEvent.Register<BloomeryRecipe> event) {
        IForgeRegistry r = event.getRegistry();
        for (Metal metal : RegistryHandler.getMetals()) {
            if (metal.getTier() != Metal.Tier.TIER_III) continue;
            r.register((IForgeRegistryEntry)new BloomeryRecipe(metal, FuelManager::isItemBloomeryFuel));
        }
    }
}

