/*
 * Decompiled with CFR 0.152.
 */
package tfcmetallum.util;

import net.dries007.tfc.ConfigTFC;
import net.dries007.tfc.api.capability.forge.CapabilityForgeable;
import net.dries007.tfc.api.capability.forge.IForgeable;
import net.dries007.tfc.api.capability.forge.IForgeableMeasurableMetal;
import net.dries007.tfc.api.recipes.AlloyRecipe;
import net.dries007.tfc.api.recipes.BlastFurnaceRecipe;
import net.dries007.tfc.api.recipes.BloomeryRecipe;
import net.dries007.tfc.api.recipes.anvil.AnvilRecipe;
import net.dries007.tfc.api.recipes.quern.QuernRecipe;
import net.dries007.tfc.api.registries.TFCRegistries;
import net.dries007.tfc.api.registries.TFCRegistryEvent;
import net.dries007.tfc.api.types.Metal;
import net.dries007.tfc.api.types.Ore;
import net.dries007.tfc.objects.Powder;
import net.dries007.tfc.objects.inventory.ingredient.IIngredient;
import net.dries007.tfc.objects.items.ItemPowder;
import net.dries007.tfc.objects.items.ItemsTFC;
import net.dries007.tfc.objects.items.itemblock.ItemBlockMetalLamp;
import net.dries007.tfc.objects.items.metal.ItemMetal;
import net.dries007.tfc.types.DefaultMetals;
import net.dries007.tfc.util.OreDictionaryHelper;
import net.dries007.tfc.util.forge.ForgeRule;
import net.dries007.tfc.util.fuel.FuelManager;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistryModifiable;
import tfcmetallum.ConfigTFCM;
import tfcmetallum.objects.ArmorMaterialsTFCM;
import tfcmetallum.objects.ToolMaterialsTFCM;

@Mod.EventBusSubscriber(modid="tfcmetallum")
public final class RegistryHandler {
    public static final ResourceLocation ALUMINIUM = new ResourceLocation("tfc", "aluminium");
    public static final ResourceLocation ALUMINIUM_BRASS = new ResourceLocation("tfc", "aluminium_brass");
    public static final ResourceLocation ANTIMONY = new ResourceLocation("tfc", "antimony");
    public static final ResourceLocation ARDITE = new ResourceLocation("tfc", "ardite");
    public static final ResourceLocation COBALT = new ResourceLocation("tfc", "cobalt");
    public static final ResourceLocation CONSTANTAN = new ResourceLocation("tfc", "constantan");
    public static final ResourceLocation ELECTRUM = new ResourceLocation("tfc", "electrum");
    public static final ResourceLocation INVAR = new ResourceLocation("tfc", "invar");
    public static final ResourceLocation MANYULLYN = new ResourceLocation("tfc", "manyullyn");
    public static final ResourceLocation MITHRIL = new ResourceLocation("tfc", "mithril");
    public static final ResourceLocation OSMIUM = new ResourceLocation("tfc", "osmium");
    public static final ResourceLocation TITANIUM = new ResourceLocation("tfc", "titanium");
    public static final ResourceLocation TUNGSTEN = new ResourceLocation("tfc", "tungsten");
    public static final ResourceLocation TUNGSTEN_STEEL = new ResourceLocation("tfc", "tungsten_steel");
    public static final ResourceLocation NICKEL_SILVER = new ResourceLocation("tfc", "nickel_silver");
    public static final ResourceLocation RED_ALLOY = new ResourceLocation("tfc", "red_alloy");
    public static final ResourceLocation BORON = new ResourceLocation("tfc", "boron");
    public static final ResourceLocation FERROBORON = new ResourceLocation("tfc", "ferroboron");
    public static final ResourceLocation THORIUM = new ResourceLocation("tfc", "thorium");
    public static final ResourceLocation LITHIUM = new ResourceLocation("tfc", "lithium");
    public static final ResourceLocation MANGANESE = new ResourceLocation("tfc", "manganese");
    public static final ResourceLocation MAGNESIUM = new ResourceLocation("tfc", "magnesium");
    public static final ResourceLocation BERYLLIUM = new ResourceLocation("tfc", "beryllium");
    public static final ResourceLocation BERYLLIUM_COPPER = new ResourceLocation("tfc", "beryllium_copper");
    public static final ResourceLocation ZIRCONIUM = new ResourceLocation("tfc", "zirconium");
    public static final ResourceLocation ZIRCALOY = new ResourceLocation("tfc", "zircaloy");
    public static final ResourceLocation HSLA_STEEL = new ResourceLocation("tfc", "hsla_steel");
    public static final ResourceLocation MAGNESIUM_DIBORIDE = new ResourceLocation("tfc", "magnesium_diboride");
    public static final ResourceLocation TOUGH = new ResourceLocation("tfc", "tough");
    public static final ResourceLocation URANIUM = new ResourceLocation("tfc", "uranium");
    public static final ResourceLocation NATIVE_ARDITE = new ResourceLocation("tfc", "native_ardite");
    public static final ResourceLocation NATIVE_OSMIUM = new ResourceLocation("tfc", "native_osmium");
    public static final ResourceLocation BAUXITE = new ResourceLocation("tfc", "bauxite");
    public static final ResourceLocation WOLFRAMITE = new ResourceLocation("tfc", "wolframite");
    public static final ResourceLocation COBALTITE = new ResourceLocation("tfc", "cobaltite");
    public static final ResourceLocation STIBNITE = new ResourceLocation("tfc", "stibnite");
    public static final ResourceLocation RUTILE = new ResourceLocation("tfc", "rutile");
    public static final ResourceLocation TETRABORATE = new ResourceLocation("tfc", "tetraborate");
    public static final ResourceLocation SPODUMENE = new ResourceLocation("tfc", "spodumene");
    public static final ResourceLocation THORIANITE = new ResourceLocation("tfc", "thorianite");
    public static final ResourceLocation PYROLUSITE = new ResourceLocation("tfc", "pyrolusite");
    public static final ResourceLocation MAGNESITE = new ResourceLocation("tfc", "magnesite");
    public static final ResourceLocation BERYL = new ResourceLocation("tfc", "beryl");
    public static final ResourceLocation ZIRCON = new ResourceLocation("tfc", "zircon");
    public static final ResourceLocation CHROMITE = new ResourceLocation("tfc", "chromite");
    public static final ResourceLocation VILLIAUMITE = new ResourceLocation("tfc", "villiaumite");
    public static final ResourceLocation RHODOCHROSITE = new ResourceLocation("tfc", "rhodochrosite");
    public static final ResourceLocation FLUORITE = new ResourceLocation("tfc", "fluorite");
    public static final ResourceLocation CAROBBIITE = new ResourceLocation("tfc", "carobbiite");
    public static final ResourceLocation ARSENIC = new ResourceLocation("tfc", "arsenic");

    @SubscribeEvent
    public static void onPreRegisterMetal(TFCRegistryEvent.RegisterPreBlock<Metal> event) {
        IForgeRegistry r = event.getRegistry();
        r.registerAll((IForgeRegistryEntry[])new Metal[]{new Metal(ANTIMONY, Metal.Tier.TIER_I, true, 0.25f, 630.0f, -1579019, null, null), new Metal(LITHIUM, Metal.Tier.TIER_II, true, 0.25f, 630.0f, 13224899, null, null), new Metal(CONSTANTAN, Metal.Tier.TIER_II, true, 0.5f, 1200.0f, -2979724, null, null), new Metal(ELECTRUM, Metal.Tier.TIER_II, true, 0.5f, 1200.0f, -2115248, null, null), new Metal(NICKEL_SILVER, Metal.Tier.TIER_II, true, 0.35f, 1450.0f, -5987163, ToolMaterialsTFCM.NICKEL_SILVER, ArmorMaterialsTFCM.NICKEL_SILVER), new Metal(RED_ALLOY, Metal.Tier.TIER_II, true, 0.35f, 1080.0f, -2462098, null, null), new Metal(MITHRIL, Metal.Tier.TIER_II, true, 0.35f, 940.0f, -7677194, ToolMaterialsTFCM.MITHRIL, ArmorMaterialsTFCM.MITHRIL), new Metal(INVAR, Metal.Tier.TIER_III, true, 0.35f, 1450.0f, -5592418, ToolMaterialsTFCM.INVAR, ArmorMaterialsTFCM.INVAR), new Metal(ALUMINIUM, Metal.Tier.TIER_III, true, 0.3f, 660.0f, -2491396, ToolMaterialsTFCM.ALUMINIUM, ArmorMaterialsTFCM.ALUMINIUM), new Metal(ALUMINIUM_BRASS, Metal.Tier.TIER_III, true, 0.3f, 630.0f, -2303298, null, null), new Metal(MAGNESIUM, Metal.Tier.TIER_III, true, 0.3f, 650.0f, -6848107, null, null), new Metal(MANGANESE, Metal.Tier.TIER_III, true, 0.29f, 1250.0f, -7104600, null, null), new Metal(BORON, Metal.Tier.TIER_III, true, 0.3f, 630.0f, -14342875, ToolMaterialsTFCM.BORON, ArmorMaterialsTFCM.BORON), new Metal(MAGNESIUM_DIBORIDE, Metal.Tier.TIER_III, true, 0.35f, 2000.0f, -12175074, null, null), new Metal(THORIUM, Metal.Tier.TIER_III, true, 0.3f, 630.0f, -12761784, null, null), new Metal(URANIUM, Metal.Tier.TIER_III, true, 0.3f, 3000.0f, -12949724, null, null), new Metal(ARDITE, Metal.Tier.TIER_III, true, 0.3f, 1050.0f, -1010156, null, null), new Metal(COBALT, Metal.Tier.TIER_III, true, 0.3f, 1495.0f, -9656603, ToolMaterialsTFCM.COBALT, ArmorMaterialsTFCM.COBALT), new Metal(MANYULLYN, Metal.Tier.TIER_IV, true, 0.3f, 1550.0f, -5221696, ToolMaterialsTFCM.MANYULLYN, ArmorMaterialsTFCM.MANYULLYN), new Metal(HSLA_STEEL, Metal.Tier.TIER_V, true, 0.35f, 2000.0f, -12631680, null, null), new Metal(FERROBORON, Metal.Tier.TIER_V, true, 0.3f, 3000.0f, -11842741, null, null), new Metal(BERYLLIUM, Metal.Tier.TIER_VI, true, 0.35f, 1300.0f, -1774886, null, null), new Metal(BERYLLIUM_COPPER, Metal.Tier.TIER_VI, true, 0.35f, 1500.0f, -1397104, ToolMaterialsTFCM.BERYLLIUM_COPPER, ArmorMaterialsTFCM.BERYLLIUM_COPPER), new Metal(OSMIUM, Metal.Tier.TIER_VI, true, 0.35f, 3025.0f, -4663074, ToolMaterialsTFCM.OSMIUM, ArmorMaterialsTFCM.OSMIUM), new Metal(TITANIUM, Metal.Tier.TIER_VI, true, 0.3f, 1700.0f, -4012852, ToolMaterialsTFCM.TITANIUM, ArmorMaterialsTFCM.TITANIUM), new Metal(TUNGSTEN, Metal.Tier.TIER_VI, true, 0.2f, 3400.0f, -12499637, ToolMaterialsTFCM.TUNGSTEN, ArmorMaterialsTFCM.TUNGSTEN), new Metal(TUNGSTEN_STEEL, Metal.Tier.TIER_VI, true, 0.2f, 3695.0f, -11116690, ToolMaterialsTFCM.TUNGSTEN_STEEL, ArmorMaterialsTFCM.TUNGSTEN_STEEL), new Metal(ZIRCONIUM, Metal.Tier.TIER_VI, true, 0.35f, 1500.0f, -9145049, null, null), new Metal(ZIRCALOY, Metal.Tier.TIER_VI, true, 0.35f, 1500.0f, -12369350, ToolMaterialsTFCM.ZIRCALOY, ArmorMaterialsTFCM.ZIRCALOY), new Metal(TOUGH, Metal.Tier.TIER_VI, true, 0.3f, 3000.0f, -12637343, null, null)});
    }

    @SubscribeEvent
    public static void onPreRegisterOre(TFCRegistryEvent.RegisterPreBlock<Ore> event) {
        IForgeRegistry r = event.getRegistry();
        r.registerAll((IForgeRegistryEntry[])new Ore[]{new Ore(STIBNITE, ANTIMONY, true), new Ore(SPODUMENE, LITHIUM, true), new Ore(NATIVE_ARDITE, ARDITE, false), new Ore(NATIVE_OSMIUM, OSMIUM, false), new Ore(BAUXITE, ALUMINIUM, false), new Ore(WOLFRAMITE, TUNGSTEN, false), new Ore(COBALTITE, COBALT, false), new Ore(RUTILE, TITANIUM, false), new Ore(THORIANITE, THORIUM, false), new Ore(PYROLUSITE, MANGANESE, false), new Ore(MAGNESITE, MAGNESIUM, false), new Ore(ZIRCON, ZIRCONIUM, false), new Ore(CHROMITE), new Ore(VILLIAUMITE), new Ore(RHODOCHROSITE), new Ore(FLUORITE), new Ore(CAROBBIITE), new Ore(ARSENIC)});
    }

    @SubscribeEvent
    public static void onRegisterAlloyRecipe(RegistryEvent.Register<AlloyRecipe> event) {
        IForgeRegistry r = event.getRegistry();
        r.registerAll((IForgeRegistryEntry[])new AlloyRecipe[]{new AlloyRecipe.Builder(CONSTANTAN).add(DefaultMetals.COPPER, 0.4, 0.6).add(DefaultMetals.NICKEL, 0.4, 0.6).build(), new AlloyRecipe.Builder(ELECTRUM).add(DefaultMetals.GOLD, 0.4, 0.6).add(DefaultMetals.SILVER, 0.4, 0.6).build(), new AlloyRecipe.Builder(MITHRIL).add(DefaultMetals.COPPER, 0.88, 0.92).add(ANTIMONY, 0.08, 0.12).build(), new AlloyRecipe.Builder(INVAR).add(DefaultMetals.WROUGHT_IRON, 0.6, 0.7).add(DefaultMetals.NICKEL, 0.3, 0.4).build(), new AlloyRecipe.Builder(ALUMINIUM_BRASS).add(ALUMINIUM, 0.65, 0.85).add(DefaultMetals.COPPER, 0.15, 0.35).build(), new AlloyRecipe.Builder(MANYULLYN).add(COBALT, 0.4, 0.6).add(ARDITE, 0.4, 0.6).build(), new AlloyRecipe.Builder(TUNGSTEN_STEEL).add(TUNGSTEN, 0.02, 0.18).add(DefaultMetals.STEEL, 0.72, 0.98).build(), new AlloyRecipe.Builder(NICKEL_SILVER).add(DefaultMetals.COPPER, 0.5, 0.65).add(DefaultMetals.ZINC, 0.1, 0.3).add(DefaultMetals.NICKEL, 0.1, 0.3).build(), new AlloyRecipe.Builder(FERROBORON).add(DefaultMetals.STEEL, 0.4, 0.6).add(BORON, 0.4, 0.6).build(), new AlloyRecipe.Builder(HSLA_STEEL).add(DefaultMetals.STEEL, 0.4, 0.6).add(MANGANESE, 0.4, 0.6).build(), new AlloyRecipe.Builder(MAGNESIUM_DIBORIDE).add(BORON, 0.4, 0.6).add(MAGNESIUM, 0.2, 0.4).build(), new AlloyRecipe.Builder(BERYLLIUM_COPPER).add(BERYLLIUM, 0.3, 0.6).add(DefaultMetals.COPPER, 0.3, 0.6).add(ALUMINIUM, 0.1, 0.3).build(), new AlloyRecipe.Builder(ZIRCALOY).add(ZIRCONIUM, 0.72, 0.98).add(DefaultMetals.TIN, 0.2, 0.4).build(), new AlloyRecipe.Builder(TOUGH).add(FERROBORON, 0.4, 0.6).add(LITHIUM, 0.4, 0.6).build()});
    }

    @SubscribeEvent
    public static void onRegisterBloomeryRecipeEvent(RegistryEvent.Register<BloomeryRecipe> event) {
        IForgeRegistry registry = event.getRegistry();
        if (ConfigTFCM.RECIPES.aluminium) {
            registry.register((IForgeRegistryEntry)new BloomeryRecipe((Metal)TFCRegistries.METALS.getValue(ALUMINIUM), FuelManager::isItemBloomeryFuel));
        }
        if (ConfigTFCM.RECIPES.ardite) {
            registry.register((IForgeRegistryEntry)new BloomeryRecipe((Metal)TFCRegistries.METALS.getValue(ARDITE), FuelManager::isItemBloomeryFuel));
        }
        if (ConfigTFCM.RECIPES.cobalt) {
            registry.register((IForgeRegistryEntry)new BloomeryRecipe((Metal)TFCRegistries.METALS.getValue(COBALT), FuelManager::isItemBloomeryFuel));
        }
        if (ConfigTFCM.RECIPES.thorium) {
            registry.register((IForgeRegistryEntry)new BloomeryRecipe((Metal)TFCRegistries.METALS.getValue(THORIUM), FuelManager::isItemBloomeryFuel));
        }
        if (ConfigTFCM.RECIPES.manganese) {
            registry.register((IForgeRegistryEntry)new BloomeryRecipe((Metal)TFCRegistries.METALS.getValue(MANGANESE), FuelManager::isItemBloomeryFuel));
        }
        if (ConfigTFCM.RECIPES.magnesium) {
            registry.register((IForgeRegistryEntry)new BloomeryRecipe((Metal)TFCRegistries.METALS.getValue(MAGNESIUM), FuelManager::isItemBloomeryFuel));
        }
    }

    @SubscribeEvent
    public static void onRegisterBlastFurnaceRecipeEvent(RegistryEvent.Register<BlastFurnaceRecipe> event) {
        Metal zirconium;
        Metal beryllium;
        Metal tungsten;
        Metal titanium;
        Metal osmium;
        IForgeRegistry registry = event.getRegistry();
        if (ConfigTFCM.RECIPES.osmium && (osmium = (Metal)TFCRegistries.METALS.getValue(OSMIUM)) != null) {
            registry.register((IForgeRegistryEntry)new BlastFurnaceRecipe(osmium, osmium, IIngredient.of((String)"dustFlux")));
        }
        if (ConfigTFCM.RECIPES.titanium && (titanium = (Metal)TFCRegistries.METALS.getValue(TITANIUM)) != null) {
            registry.register((IForgeRegistryEntry)new BlastFurnaceRecipe(titanium, titanium, IIngredient.of((String)"dustFlux")));
        }
        if (ConfigTFCM.RECIPES.tungsten && (tungsten = (Metal)TFCRegistries.METALS.getValue(TUNGSTEN)) != null) {
            registry.register((IForgeRegistryEntry)new BlastFurnaceRecipe(tungsten, tungsten, IIngredient.of((String)"dustFlux")));
        }
        if (ConfigTFCM.RECIPES.beryllium && (beryllium = (Metal)TFCRegistries.METALS.getValue(BERYLLIUM)) != null) {
            registry.register((IForgeRegistryEntry)new BlastFurnaceRecipe(beryllium, beryllium, IIngredient.of((String)"dustFlux")));
        }
        if (ConfigTFCM.RECIPES.zirconium && (zirconium = (Metal)TFCRegistries.METALS.getValue(ZIRCONIUM)) != null) {
            registry.register((IForgeRegistryEntry)new BlastFurnaceRecipe(zirconium, zirconium, IIngredient.of((String)"dustFlux")));
        }
    }

    @SubscribeEvent
    public static void onRegisterAnvilRecipeEvent(RegistryEvent.Register<AnvilRecipe> event) {
        Metal manganese;
        Metal magnesium;
        Metal thorium;
        Metal cobalt;
        Metal ardite;
        Metal aluminium;
        IForgeRegistry r = event.getRegistry();
        if (ConfigTFCM.RECIPES.aluminium && (aluminium = (Metal)TFCRegistries.METALS.getValue(ALUMINIUM)) != null) {
            r.register((IForgeRegistryEntry)new AnvilRecipe(new ResourceLocation("tfcmetallum", "aluminium_bloom"), RegistryHandler.getBloomIngredient(aluminium), new ItemStack(ItemMetal.get((Metal)aluminium, (Metal.ItemType)Metal.ItemType.INGOT)), Metal.Tier.TIER_II, null, new ForgeRule[]{ForgeRule.HIT_LAST, ForgeRule.HIT_SECOND_LAST, ForgeRule.HIT_THIRD_LAST}));
        }
        if (ConfigTFCM.RECIPES.ardite && (ardite = (Metal)TFCRegistries.METALS.getValue(ARDITE)) != null) {
            r.register((IForgeRegistryEntry)new AnvilRecipe(new ResourceLocation("tfcmetallum", "ardite_bloom"), RegistryHandler.getBloomIngredient(ardite), new ItemStack(ItemMetal.get((Metal)ardite, (Metal.ItemType)Metal.ItemType.INGOT)), Metal.Tier.TIER_II, null, new ForgeRule[]{ForgeRule.HIT_LAST, ForgeRule.HIT_SECOND_LAST, ForgeRule.HIT_THIRD_LAST}));
        }
        if (ConfigTFCM.RECIPES.cobalt && (cobalt = (Metal)TFCRegistries.METALS.getValue(COBALT)) != null) {
            r.register((IForgeRegistryEntry)new AnvilRecipe(new ResourceLocation("tfcmetallum", "cobalt_bloom"), RegistryHandler.getBloomIngredient(cobalt), new ItemStack(ItemMetal.get((Metal)cobalt, (Metal.ItemType)Metal.ItemType.INGOT)), Metal.Tier.TIER_II, null, new ForgeRule[]{ForgeRule.HIT_LAST, ForgeRule.HIT_SECOND_LAST, ForgeRule.HIT_THIRD_LAST}));
        }
        if (ConfigTFCM.RECIPES.thorium && (thorium = (Metal)TFCRegistries.METALS.getValue(THORIUM)) != null) {
            r.register((IForgeRegistryEntry)new AnvilRecipe(new ResourceLocation("tfcmetallum", "thorium_bloom"), RegistryHandler.getBloomIngredient(thorium), new ItemStack(ItemMetal.get((Metal)thorium, (Metal.ItemType)Metal.ItemType.INGOT)), Metal.Tier.TIER_II, null, new ForgeRule[]{ForgeRule.HIT_LAST, ForgeRule.HIT_SECOND_LAST, ForgeRule.HIT_THIRD_LAST}));
        }
        if (ConfigTFCM.RECIPES.magnesium && (magnesium = (Metal)TFCRegistries.METALS.getValue(MAGNESIUM)) != null) {
            r.register((IForgeRegistryEntry)new AnvilRecipe(new ResourceLocation("tfcmetallum", "magnesium_bloom"), RegistryHandler.getBloomIngredient(magnesium), new ItemStack(ItemMetal.get((Metal)magnesium, (Metal.ItemType)Metal.ItemType.INGOT)), Metal.Tier.TIER_II, null, new ForgeRule[]{ForgeRule.HIT_LAST, ForgeRule.HIT_SECOND_LAST, ForgeRule.HIT_THIRD_LAST}));
        }
        if (ConfigTFCM.RECIPES.manganese && (manganese = (Metal)TFCRegistries.METALS.getValue(MANGANESE)) != null) {
            r.register((IForgeRegistryEntry)new AnvilRecipe(new ResourceLocation("tfcmetallum", "manganese_bloom"), RegistryHandler.getBloomIngredient(manganese), new ItemStack(ItemMetal.get((Metal)manganese, (Metal.ItemType)Metal.ItemType.INGOT)), Metal.Tier.TIER_II, null, new ForgeRule[]{ForgeRule.HIT_LAST, ForgeRule.HIT_SECOND_LAST, ForgeRule.HIT_THIRD_LAST}));
        }
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        Metal aluminium = (Metal)TFCRegistries.METALS.getValue(ALUMINIUM);
        if (aluminium != null) {
            for (Metal.ItemType type : Metal.ItemType.values()) {
                Item metalItem = ItemMetal.get((Metal)aluminium, (Metal.ItemType)type);
                if (metalItem == null || metalItem instanceof ItemBlockMetalLamp) continue;
                if (type == Metal.ItemType.DOUBLE_INGOT) {
                    OreDictionary.registerOre((String)OreDictionaryHelper.toString((Object[])new Object[]{"ingot", "double", "aluminum"}), (Item)metalItem);
                    continue;
                }
                if (type == Metal.ItemType.DOUBLE_SHEET) {
                    OreDictionary.registerOre((String)OreDictionaryHelper.toString((Object[])new Object[]{"sheet", "double", "aluminum"}), (Item)metalItem);
                    continue;
                }
                if (type.isToolItem()) continue;
                OreDictionary.registerOre((String)OreDictionaryHelper.toString((Object[])new Object[]{type, "aluminum"}), (Item)metalItem);
                if (type != Metal.ItemType.SHEET || !ConfigTFC.General.MISC.dictionaryPlates) continue;
                OreDictionary.registerOre((String)OreDictionaryHelper.toString((Object[])new Object[]{"plate", "aluminum"}), (Item)metalItem);
            }
        }
    }

    @SubscribeEvent
    public static void onRegisterQuernRecipeEvent(RegistryEvent.Register<QuernRecipe> event) {
        IForgeRegistry r = event.getRegistry();
        Metal uranium = (Metal)TFCRegistries.METALS.getValue(URANIUM);
        Metal boron = (Metal)TFCRegistries.METALS.getValue(BORON);
        if (uranium != null) {
            r.register(new QuernRecipe(IIngredient.of((String)"gemPitchblende"), new ItemStack(ItemMetal.get((Metal)uranium, (Metal.ItemType)Metal.ItemType.DUST), 4)).setRegistryName("uranium_dust"));
        }
        if (boron != null) {
            IForgeRegistryModifiable modRegistry = (IForgeRegistryModifiable)TFCRegistries.QUERN;
            modRegistry.remove(new ResourceLocation("tfc", "borax"));
            r.register(new QuernRecipe(IIngredient.of((String)"gemBorax"), new ItemStack(ItemMetal.get((Metal)boron, (Metal.ItemType)Metal.ItemType.DUST), 4)).setRegistryName("boron_dust"));
        }
        r.register(new QuernRecipe(IIngredient.of((String)"gemFluorite"), new ItemStack((Item)ItemPowder.get((Powder)Powder.FLUX), 6)).setRegistryName("fluorite_flux"));
    }

    private static IIngredient<ItemStack> getBloomIngredient(Metal metal) {
        return x -> {
            IForgeable cap;
            if (x.func_77973_b() == ItemsTFC.REFINED_BLOOM && (cap = (IForgeable)x.getCapability(CapabilityForgeable.FORGEABLE_CAPABILITY, null)) instanceof IForgeableMeasurableMetal) {
                return ((IForgeableMeasurableMetal)cap).getMetal() == metal && ((IForgeableMeasurableMetal)cap).getMetalAmount() == 100;
            }
            return false;
        };
    }
}

