/*
 * Decompiled with CFR 0.152.
 */
package com.black_dog20.mininglantern.item;

import baubles.api.BaubleType;
import baubles.api.IBauble;
import com.black_dog20.mininglantern.capability.ILanternCapabilityHandler;
import com.black_dog20.mininglantern.capability.LanternCapabilityHandler;
import com.black_dog20.mininglantern.client.settings.Keybindings;
import com.black_dog20.mininglantern.init.ModItems;
import com.black_dog20.mininglantern.item.ItemBase;
import com.black_dog20.mininglantern.utility.InventoryHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Optional.Interface(iface="baubles.api.IBauble", modid="baubles")
public class ItemLantern
extends ItemBase
implements IBauble {
    public ItemLantern(String name) {
        super(name);
        this.func_77625_d(1);
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.func_185043_a(new ResourceLocation("state"), new IItemPropertyGetter(){

            public float func_185085_a(ItemStack stack, World worldIn, EntityLivingBase entityIn) {
                NBTTagCompound nbt;
                ILanternCapabilityHandler mh;
                if (entityIn != null ? (mh = (ILanternCapabilityHandler)entityIn.getCapability(LanternCapabilityHandler.CAP, null)) != null && !mh.getHasLanternOn() : stack.func_77942_o() && (nbt = stack.func_77978_p()).func_74764_b("MININGLANTERN_ON") && !nbt.func_74767_n("MININGLANTERN_ON")) {
                    return 0.0f;
                }
                return -1.0f;
            }
        });
    }

    @Optional.Method(modid="baubles")
    public BaubleType getBaubleType(ItemStack itemstack) {
        return BaubleType.TRINKET;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.add(I18n.func_135052_a((String)"tooltip.mininglantern:activate", (Object[])new Object[]{TextFormatting.BLUE, Keybindings.TOGGLE_LIGHT.getDisplayName(), TextFormatting.GRAY}));
        if (Loader.isModLoaded((String)"albedo")) {
            tooltip.add(I18n.func_135052_a((String)"tooltip.mininglantern:loaded", (Object[])new Object[0]));
        } else {
            tooltip.add(I18n.func_135052_a((String)"tooltip.mininglantern:notloaded", (Object[])new Object[0]));
        }
    }

    @SubscribeEvent
    public void onPlayerUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntity() instanceof EntityPlayer && !event.getEntity().field_70170_p.field_72995_K) {
            EntityPlayer player = (EntityPlayer)event.getEntity();
            ILanternCapabilityHandler mh = LanternCapabilityHandler.instanceFor(player);
            if (mh != null && !mh.getHasLantern() && InventoryHelper.doesPlayerHave(player, new ItemStack(ModItems.lantern))) {
                mh.setHasLantern(true);
            } else if (mh != null && mh.getHasLantern() && !InventoryHelper.doesPlayerHave(player, new ItemStack(ModItems.lantern))) {
                mh.setHasLantern(false);
            }
        }
    }
}

