/*
 * Decompiled with CFR 0.152.
 */
package com.black_dog20.mininglantern.handler;

import com.black_dog20.mininglantern.capability.ILanternCapabilityHandler;
import com.black_dog20.mininglantern.capability.LanternCapabilityHandler;
import com.black_dog20.mininglantern.config.ModConfig;
import com.black_dog20.mininglantern.utility.Helper;
import elucent.albedo.event.RenderEntityEvent;
import elucent.albedo.lighting.Light;
import elucent.albedo.lighting.LightManager;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LightHandler {
    private static int playerRange = 30;
    private static float lightRange = 16.0f;

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onEntityRender(RenderEntityEvent event) {
        if (!ModConfig.others_light) {
            return;
        }
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        if (world == null) {
            return;
        }
        Entity e = event.getEntity();
        if (!(e instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)e;
        EntityPlayerSP theplayer = Minecraft.func_71410_x().field_71439_g;
        List<EntityPlayer> list = Helper.getPlayersInRadius((Entity)player, playerRange);
        ILanternCapabilityHandler lch = LanternCapabilityHandler.instanceFor(player);
        if (!player.equals((Object)theplayer) && !list.contains(player) && lch != null && lch.getHasLantern() && lch.getHasLanternOn()) {
            Light l = Light.builder().color(255.0f, 255.0f, 204.0f, 0.005f).pos((Entity)player).radius(lightRange).build();
            LightManager.lights.add(l);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onRenderWorld(RenderWorldLastEvent event) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        ILanternCapabilityHandler lch = LanternCapabilityHandler.instanceFor((EntityPlayer)player);
        if (lch != null && lch.getHasLantern() && lch.getHasLanternOn()) {
            Light l = Light.builder().color(255.0f, 255.0f, 204.0f, 0.005f).pos((Entity)player).radius(lightRange).build();
            LightManager.lights.add(l);
        }
        if (ModConfig.others_light) {
            List<EntityPlayer> list = Helper.getPlayersInRadius((Entity)player, playerRange);
            for (EntityPlayer entity : list) {
                ILanternCapabilityHandler lch2 = LanternCapabilityHandler.instanceFor(entity);
                if (lch2 == null || !lch2.getHasLantern() || !lch2.getHasLanternOn()) continue;
                Light l = Light.builder().color(255.0f, 255.0f, 204.0f, 0.005f).pos((Entity)entity).radius(lightRange).build();
                LightManager.lights.add(l);
            }
        }
    }
}

