/*
 * Decompiled with CFR 0.152.
 */
package com.black_dog20.mininglantern.handler;

import com.black_dog20.mininglantern.capability.ILanternCapabilityHandler;
import com.black_dog20.mininglantern.capability.LanternCapabilityHandler;
import com.black_dog20.mininglantern.utility.Helper;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="mininglantern")
public class EventHandler {
    private static int range = 8;

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onEntityCheckSpawn(LivingSpawnEvent.CheckSpawn event) {
        if (event.getResult() == Event.Result.ALLOW) {
            if (event.isSpawner()) {
                return;
            }
            List<EntityPlayer> list = Helper.getPlayersInRadius(event.getEntity(), range);
            for (EntityPlayer entityPlayer : list) {
                ILanternCapabilityHandler lch = LanternCapabilityHandler.instanceFor(entityPlayer);
                if (lch == null || !lch.getHasLantern() || !lch.getHasLanternOn()) continue;
                event.setResult(Event.Result.DENY);
            }
        }
    }
}

