/*
 * Decompiled with CFR 0.152.
 */
package com.black_dog20.mininglantern.capability;

import com.black_dog20.mininglantern.capability.ILanternCapabilityHandler;
import com.black_dog20.mininglantern.network.PacketHandler;
import com.black_dog20.mininglantern.network.message.MessageSyncLanternCapability;
import com.black_dog20.mininglantern.network.message.MessageSyncLanternCapabilityTracking;
import java.util.concurrent.Callable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class LanternCapabilityHandler
implements ILanternCapabilityHandler,
ICapabilitySerializable<NBTTagCompound> {
    public static final int SIZE = 29;
    @CapabilityInject(value=ILanternCapabilityHandler.class)
    public static final Capability<ILanternCapabilityHandler> CAP = null;
    private boolean hasLantern = false;
    private boolean lanternOn = false;
    private boolean dirty = false;

    @Override
    public void markDirty() {
        this.dirty = true;
    }

    @Override
    public void setHasLantern(boolean hasLantern) {
        this.hasLantern = hasLantern;
        this.dirty = true;
    }

    @Override
    public boolean getHasLantern() {
        return this.hasLantern;
    }

    @Override
    public void setHasLanternOn(boolean hasLanternOn) {
        this.lanternOn = hasLanternOn;
        this.dirty = true;
    }

    @Override
    public boolean getHasLanternOn() {
        return this.lanternOn;
    }

    @Override
    public void copyTo(ILanternCapabilityHandler other) {
        other.setHasLantern(this.hasLantern);
        other.setHasLanternOn(this.lanternOn);
    }

    @Override
    public void updateClient(EntityPlayer player) {
        if (!player.field_70170_p.field_72995_K && this.dirty) {
            PacketHandler.network.sendTo((IMessage)new MessageSyncLanternCapability(this), (EntityPlayerMP)player);
            ((WorldServer)player.field_70170_p).func_73039_n().func_151247_a((Entity)player, PacketHandler.network.getPacketFrom((IMessage)new MessageSyncLanternCapabilityTracking(this, player)));
            this.dirty = false;
        }
    }

    public static ILanternCapabilityHandler instanceFor(EntityPlayer player) {
        return (ILanternCapabilityHandler)player.getCapability(CAP, null);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CAP;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        try {
            return (T)(capability == CAP ? CAP.cast((Object)this) : null);
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    public NBTTagCompound serializeNBT() {
        return (NBTTagCompound)CAP.getStorage().writeNBT(CAP, (Object)this, null);
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        CAP.getStorage().readNBT(CAP, (Object)this, null, (NBTBase)nbt);
        this.dirty = true;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.hasLantern = nbt.func_74767_n("hasLantern");
        this.lanternOn = nbt.func_74767_n("lanternOn");
    }

    @Override
    public NBTTagCompound writeToNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74757_a("hasLantern", this.hasLantern);
        nbt.func_74757_a("lanternOn", this.lanternOn);
        return nbt;
    }

    public static final class Factory
    implements Callable<LanternCapabilityHandler> {
        @Override
        public LanternCapabilityHandler call() throws Exception {
            return new LanternCapabilityHandler();
        }
    }
}

