/*
 * Decompiled with CFR 0.152.
 */
package com.lumintorious.ambiental.modifiers;

import com.lumintorious.ambiental.capability.TemperatureCapability;
import com.lumintorious.ambiental.modifiers.BlockModifier;
import com.lumintorious.ambiental.modifiers.EnvironmentalModifier;
import net.dries007.tfc.objects.te.TEBloomery;
import net.dries007.tfc.objects.te.TECharcoalForge;
import net.dries007.tfc.objects.te.TEFirePit;
import net.dries007.tfc.objects.te.TELamp;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;

public class TileEntityModifier
extends BlockModifier {
    public TileEntityModifier(String unlocalizedName) {
        super(unlocalizedName);
    }

    public TileEntityModifier(String unlocalizedName, float change, float potency) {
        super(unlocalizedName, change, potency);
    }

    public TileEntityModifier(String unlocalizedName, float change, float potency, boolean affectedByDistance) {
        super(unlocalizedName, change, potency, affectedByDistance);
    }

    private static boolean hasProtection(EntityPlayer player) {
        ItemStack stack = player.func_184582_a(EntityEquipmentSlot.CHEST);
        return stack != null && !stack.func_190926_b();
    }

    public static TileEntityModifier handleCharcoalForge(TileEntity tile, EntityPlayer player) {
        if (tile instanceof TECharcoalForge) {
            TECharcoalForge forge = (TECharcoalForge)tile;
            float temp = forge.getField(0);
            float change = temp / 140.0f;
            float potency = temp / 350.0f;
            if (TileEntityModifier.hasProtection(player)) {
                change = 1.0f;
            }
            return new TileEntityModifier("charcoal_forge", change, potency);
        }
        return null;
    }

    public static TileEntityModifier handleFirePit(TileEntity tile, EntityPlayer player) {
        if (tile instanceof TEFirePit) {
            TEFirePit pit = (TEFirePit)tile;
            float temp = pit.getField(0);
            float change = temp / 100.0f;
            float potency = temp / 350.0f;
            if (TileEntityModifier.hasProtection(player)) {
                change = 1.0f;
            }
            return new TileEntityModifier("fire_pit", Math.min(6.0f, change), potency);
        }
        return null;
    }

    public static TileEntityModifier handleBloomery(TileEntity tile, EntityPlayer player) {
        if (tile instanceof TEBloomery) {
            float change;
            TEBloomery bloomery = (TEBloomery)tile;
            float potency = change = bloomery.getRemainingTicks() > 0L ? 4.0f : 0.0f;
            if (TileEntityModifier.hasProtection(player)) {
                change = 1.0f;
            }
            return new TileEntityModifier("bloomery", change, potency);
        }
        return null;
    }

    public static TileEntityModifier handleLamps(TileEntity tile, EntityPlayer player) {
        if (tile instanceof TELamp) {
            TELamp lamp = (TELamp)tile;
            if (EnvironmentalModifier.getEnvironmentTemperature(player) < TemperatureCapability.AVERAGE) {
                float change = lamp.isPowered() && lamp.getFuel() > 0 ? 1.0f : 0.0f;
                float potency = 0.0f;
                return new TileEntityModifier("lamp", change, potency, false);
            }
        }
        return null;
    }
}

