/*
 * Decompiled with CFR 0.152.
 */
package com.lumintorious.ambiental.modifiers;

import com.lumintorious.ambiental.modifiers.BaseModifier;
import io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueue;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ModifierStorage
implements Iterable<BaseModifier> {
    private HashMap<String, BaseModifier> map = new HashMap();

    private BaseModifier put(String key, BaseModifier value) {
        if (value.getChange() == 0.0f && value.getPotency() == 0.0f) {
            return null;
        }
        BaseModifier modifier = this.map.get(key);
        if (modifier != null) {
            modifier.absorb(value);
            return modifier;
        }
        return this.map.put(key, value);
    }

    public BaseModifier add(BaseModifier value) {
        if (value == null) {
            return null;
        }
        return this.put(value.getUnlocalizedName(), value);
    }

    public boolean contains(String key) {
        return this.map.containsKey(key);
    }

    public boolean contains(BaseModifier value) {
        return this.map.containsValue(value);
    }

    public BaseModifier get(String key) {
        return this.map.get(key);
    }

    public float getTotalPotency() {
        float potency = 1.0f;
        for (Map.Entry<String, BaseModifier> entry : this.map.entrySet()) {
            potency += entry.getValue().getPotency();
        }
        return potency;
    }

    public float getTargetTemperature() {
        float change = 0.0f;
        for (Map.Entry<String, BaseModifier> entry : this.map.entrySet()) {
            change += entry.getValue().getChange();
        }
        return change;
    }

    @Override
    public void forEach(MessagePassingQueue.Consumer<BaseModifier> func) {
        this.map.forEach((? super K k, ? super V v) -> func.accept(v));
    }

    @Override
    public Iterator<BaseModifier> iterator() {
        final HashMap<String, BaseModifier> map1 = this.map;
        return new Iterator<BaseModifier>(){
            private Iterator<Map.Entry<String, BaseModifier>> mapIterator;
            {
                this.mapIterator = map1.entrySet().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.mapIterator.hasNext();
            }

            @Override
            public BaseModifier next() {
                return this.mapIterator.next().getValue();
            }
        };
    }
}

