/*
 * Decompiled with CFR 0.152.
 */
package com.lumintorious.ambiental.modifiers;

import com.lumintorious.ambiental.api.IItemTemperatureOwner;
import com.lumintorious.ambiental.api.IItemTemperatureProvider;
import com.lumintorious.ambiental.api.TemperatureRegistry;
import com.lumintorious.ambiental.modifiers.BaseModifier;
import com.lumintorious.ambiental.modifiers.ModifierStorage;
import net.dries007.tfc.api.capability.heat.CapabilityItemHeat;
import net.dries007.tfc.api.capability.heat.IItemHeat;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class ItemModifier
extends BaseModifier {
    public ItemModifier(String name) {
        super(name);
    }

    public ItemModifier(String name, float change, float potency) {
        super(name, change, potency);
    }

    public static void computeModifiers(EntityPlayer player, ModifierStorage modifiers) {
        for (ItemStack stack : player.field_71069_bz.field_75153_a) {
            if (stack.hasCapability(CapabilityItemHeat.ITEM_HEAT_CAPABILITY, null)) {
                float temp;
                IItemHeat heat = (IItemHeat)stack.getCapability(CapabilityItemHeat.ITEM_HEAT_CAPABILITY, null);
                float change = temp = heat.getTemperature() / 500.0f;
                float potency = 0.0f;
                modifiers.add(new ItemModifier("heat_item", change, potency * (float)stack.func_190916_E()));
            }
            if (stack.func_77973_b() instanceof IItemTemperatureOwner) {
                IItemTemperatureOwner owner = (IItemTemperatureOwner)stack.func_77973_b();
                modifiers.add(owner.getModifier(stack, player));
            }
            for (IItemTemperatureProvider provider : TemperatureRegistry.ITEMS) {
                modifiers.add(provider.getModifier(stack, player));
            }
        }
    }
}

