/*
 * Decompiled with CFR 0.152.
 */
package com.lumintorious.ambiental.modifiers;

import com.lumintorious.ambiental.TFCAmbientalConfig;
import com.lumintorious.ambiental.api.IEnvironmentalTemperatureProvider;
import com.lumintorious.ambiental.api.TemperatureRegistry;
import com.lumintorious.ambiental.capability.TemperatureCapability;
import com.lumintorious.ambiental.effects.TempEffect;
import com.lumintorious.ambiental.modifiers.BaseModifier;
import com.lumintorious.ambiental.modifiers.ModifierStorage;
import net.dries007.tfc.api.capability.food.IFoodStatsTFC;
import net.dries007.tfc.api.capability.food.Nutrient;
import net.dries007.tfc.objects.fluids.FluidsTFC;
import net.dries007.tfc.util.climate.ClimateData;
import net.dries007.tfc.util.climate.ClimateTFC;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.potion.Potion;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public class EnvironmentalModifier
extends BaseModifier {
    public EnvironmentalModifier(String name, float change, float potency) {
        super(name, change, potency);
    }

    public static float getEnvironmentTemperature(EntityPlayer player) {
        float avg = ClimateData.DEFAULT.getRegionalTemp() + 2.0f;
        float actual = ClimateTFC.getActualTemp((World)player.field_70170_p, (BlockPos)player.func_180425_c());
        if (TFCAmbientalConfig.GENERAL.harsherTemperateAreas) {
            float diff = actual - TemperatureCapability.AVERAGE;
            float sign = Math.signum(diff);
            float generalDiff = Math.abs(avg - TemperatureCapability.AVERAGE);
            float mult0 = Math.max(0.0f, TFCAmbientalConfig.GENERAL.harsherMultiplier - 1.0f);
            float multiplier = 1.0f + Math.max(0.0f, 1.0f - generalDiff / 55.0f) * mult0;
            actual = TemperatureCapability.AVERAGE + (diff + 1.5f * sign) * multiplier;
        }
        return actual;
    }

    public static float getEnvironmentHumidity(EntityPlayer player) {
        return ClimateTFC.getRainfall((World)player.field_70170_p, (BlockPos)player.func_180425_c()) / 3000.0f;
    }

    public static EnvironmentalModifier handleFire(EntityPlayer player) {
        return player.func_70027_ad() ? new EnvironmentalModifier("on_fire", 4.0f, 4.0f) : null;
    }

    public static EnvironmentalModifier handleWater(EntityPlayer player) {
        if (player.func_70090_H()) {
            BlockPos pos = player.func_180425_c();
            IBlockState state = player.field_70170_p.func_180495_p(pos);
            if (state.func_177230_c() == FluidsTFC.HOT_WATER.get().getBlock()) {
                return new EnvironmentalModifier("in_hot_water", 5.0f, 6.0f);
            }
            if (state.func_177230_c() == Blocks.field_150353_l) {
                return new EnvironmentalModifier("in_lava", 10.0f, 5.0f);
            }
            if (state.func_177230_c() == FluidsTFC.SALT_WATER.get().getBlock() && player.field_70170_p.func_180494_b(pos).func_150561_m() == Biome.TempCategory.OCEAN) {
                return new EnvironmentalModifier("in_ocean_water", -8.0f, 6.0f);
            }
            return new EnvironmentalModifier("in_water", -5.0f, 6.0f);
        }
        return null;
    }

    public static EnvironmentalModifier handleRain(EntityPlayer player) {
        if (player.field_70170_p.func_72896_J()) {
            if (EnvironmentalModifier.getSkylight(player) < 15) {
                return new EnvironmentalModifier("rain", -2.0f, 0.1f);
            }
            return new EnvironmentalModifier("rain", -4.0f, 0.3f);
        }
        return null;
    }

    public static EnvironmentalModifier handleSprinting(EntityPlayer player) {
        if (player.func_70051_ag()) {
            return new EnvironmentalModifier("sprint", 2.0f, 0.3f);
        }
        return null;
    }

    public static EnvironmentalModifier handleUnderground(EntityPlayer player) {
        if (player.field_70170_p.func_175699_k(player.func_180425_c()) < 3 && player.func_180425_c().func_177956_o() < 135) {
            return new EnvironmentalModifier("underground", -6.0f, 0.2f);
        }
        return null;
    }

    public static EnvironmentalModifier handleShade(EntityPlayer player) {
        int light = EnvironmentalModifier.getSkylight(player);
        light = Math.max(12, light);
        float temp = EnvironmentalModifier.getEnvironmentTemperature(player);
        float avg = TemperatureCapability.AVERAGE;
        float coverage = 1.0f - (float)light / 15.0f + 0.5f;
        if (light < 15 && temp > avg) {
            return new EnvironmentalModifier("shade", -Math.abs(avg - temp) * coverage, 0.0f);
        }
        return null;
    }

    public static EnvironmentalModifier handleCozy(EntityPlayer player) {
        int skyLight = EnvironmentalModifier.getSkylight(player);
        skyLight = Math.max(11, skyLight);
        int blockLight = EnvironmentalModifier.getBlockLight(player);
        float temp = EnvironmentalModifier.getEnvironmentTemperature(player);
        float avg = TemperatureCapability.AVERAGE;
        float coverage = 1.0f - (float)skyLight / 15.0f + 0.4f;
        if (skyLight < 14 && blockLight > 4 && temp < avg - 2.0f && player.func_180425_c().func_177956_o() > 130) {
            return new EnvironmentalModifier("cozy", Math.abs(avg - 2.0f - temp) * coverage, 0.0f);
        }
        return null;
    }

    public static EnvironmentalModifier handleThirst(EntityPlayer player) {
        if (player.func_71024_bL() instanceof IFoodStatsTFC) {
            IFoodStatsTFC stats = (IFoodStatsTFC)player.func_71024_bL();
            if (EnvironmentalModifier.getEnvironmentTemperature(player) > TemperatureCapability.AVERAGE + 3.0f && stats.getThirst() > 80.0f) {
                return new EnvironmentalModifier("well_hidrated", -2.0f, 0.0f);
            }
        }
        return null;
    }

    public static EnvironmentalModifier handleFood(EntityPlayer player) {
        if (EnvironmentalModifier.getEnvironmentTemperature(player) < TemperatureCapability.AVERAGE - 3.0f && player.func_71024_bL().func_75116_a() > 16) {
            return new EnvironmentalModifier("well_fed", 2.0f, 0.0f);
        }
        return null;
    }

    public static EnvironmentalModifier handleDiet(EntityPlayer player) {
        if (player.func_71024_bL() instanceof IFoodStatsTFC) {
            IFoodStatsTFC stats = (IFoodStatsTFC)player.func_71024_bL();
            if (EnvironmentalModifier.getEnvironmentTemperature(player) < TemperatureCapability.COOL_THRESHOLD) {
                float grainLevel = stats.getNutrition().getNutrient(Nutrient.GRAIN);
                float meatLevel = stats.getNutrition().getNutrient(Nutrient.PROTEIN);
                return new EnvironmentalModifier("nutrients", 4.0f * grainLevel * meatLevel, 0.0f);
            }
            if (EnvironmentalModifier.getEnvironmentTemperature(player) > TemperatureCapability.HOT_THRESHOLD) {
                float fruitLevel = stats.getNutrition().getNutrient(Nutrient.FRUIT);
                float veggieLevel = stats.getNutrition().getNutrient(Nutrient.VEGETABLES);
                return new EnvironmentalModifier("nutrients", -4.0f * fruitLevel * veggieLevel, 0.0f);
            }
        }
        return null;
    }

    public static int getSkylight(EntityPlayer player) {
        BlockPos pos = new BlockPos((Vec3i)player.func_180425_c());
        BlockPos pos2 = pos.func_177963_a(0.0, 1.8, 0.0);
        return player.field_70170_p.func_175642_b(EnumSkyBlock.SKY, pos2);
    }

    public static int getBlockLight(EntityPlayer player) {
        BlockPos pos = new BlockPos((Vec3i)player.func_180425_c());
        pos.func_177982_a(0, 1, 0);
        return player.field_70170_p.func_175642_b(EnumSkyBlock.BLOCK, pos);
    }

    public static EnvironmentalModifier handleGeneralTemperature(EntityPlayer player) {
        int dayTicks = (int)(player.field_70170_p.func_72820_D() % 24000L);
        float dayPart = dayTicks < 6000 ? 2.0f : (dayTicks < 12000 ? 4.0f : (dayTicks < 18000 ? 1.0f : -4.0f));
        return new EnvironmentalModifier("environment", EnvironmentalModifier.getEnvironmentTemperature(player) + dayPart, EnvironmentalModifier.getEnvironmentHumidity(player));
    }

    public static EnvironmentalModifier handlePotionEffects(EntityPlayer player) {
        if (player.func_70644_a((Potion)TempEffect.COOL)) {
            return new EnvironmentalModifier("cooling_effect", -10.0f, 0.0f);
        }
        if (player.func_70644_a((Potion)TempEffect.WARM)) {
            return new EnvironmentalModifier("heating_effect", 10.0f, 0.0f);
        }
        return null;
    }

    public static void computeModifiers(EntityPlayer player, ModifierStorage modifiers) {
        for (IEnvironmentalTemperatureProvider provider : TemperatureRegistry.ENVIRONMENT) {
            modifiers.add(provider.getModifier(player));
        }
    }
}

