/*
 * Decompiled with CFR 0.152.
 */
package com.lumintorious.ambiental.modifiers;

import com.lumintorious.ambiental.api.IBlockTemperatureOwner;
import com.lumintorious.ambiental.api.IBlockTemperatureProvider;
import com.lumintorious.ambiental.api.ITileEntityTemperatureOwner;
import com.lumintorious.ambiental.api.ITileEntityTemperatureProvider;
import com.lumintorious.ambiental.api.TemperatureRegistry;
import com.lumintorious.ambiental.modifiers.BaseModifier;
import com.lumintorious.ambiental.modifiers.EnvironmentalModifier;
import com.lumintorious.ambiental.modifiers.ModifierStorage;
import com.lumintorious.ambiental.modifiers.TileEntityModifier;
import net.dries007.tfc.objects.blocks.stone.BlockRockRaw;
import net.dries007.tfc.objects.blocks.stone.BlockRockVariant;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;

public class BlockModifier
extends BaseModifier {
    public boolean affectedByDistance = false;

    public BlockModifier(String name) {
        super(name);
    }

    public BlockModifier(String name, float change, float potency) {
        super(name, change, potency);
    }

    public BlockModifier(String name, float change, float potency, boolean affectedByDistance) {
        super(name, change, potency);
        this.affectedByDistance = affectedByDistance;
    }

    public static void computeModifiers(EntityPlayer player, ModifierStorage modifiers) {
        BlockPos p = player.func_180425_c();
        BlockPos pos1 = new BlockPos(p.func_177958_n() - 9, p.func_177956_o() - 3, p.func_177952_p() - 9);
        BlockPos pos2 = new BlockPos(p.func_177958_n() + 9, p.func_177956_o() + 5, p.func_177952_p() + 9);
        Iterable allPositions = BlockPos.func_177975_b((BlockPos)pos1, (BlockPos)pos2);
        IBlockState skipState = Blocks.field_150350_a.func_176223_P();
        for (BlockPos.MutableBlockPos pos : allPositions) {
            BlockModifier modifier;
            Object owner;
            BlockModifier modifier2;
            boolean isInside;
            IBlockState state = player.field_70170_p.func_180495_p((BlockPos)pos);
            if (state == skipState || state.func_177230_c() instanceof BlockRockVariant || state.func_177230_c() instanceof BlockRockRaw) continue;
            Block block = state.func_177230_c();
            double distance = Math.sqrt(player.func_180425_c().func_177951_i((Vec3i)pos));
            float distanceMultiplier = (float)distance / 9.0f;
            distanceMultiplier = Math.min(1.0f, Math.max(0.0f, distanceMultiplier));
            distanceMultiplier = 1.0f - distanceMultiplier;
            boolean bl = isInside = EnvironmentalModifier.getSkylight(player) < 14 && EnvironmentalModifier.getBlockLight(player) > 3;
            if (isInside) {
                distanceMultiplier *= 1.3f;
            }
            if (block instanceof IBlockTemperatureOwner && (modifier2 = (owner = (IBlockTemperatureOwner)block).getModifier(state, (BlockPos)pos, player)) != null) {
                if (modifier2.affectedByDistance) {
                    modifier2.setChange(modifier2.getChange() * distanceMultiplier);
                    modifier2.setPotency(modifier2.getPotency() * distanceMultiplier);
                }
                modifiers.add(modifier2);
            }
            owner = TemperatureRegistry.BLOCKS.iterator();
            while (owner.hasNext()) {
                IBlockTemperatureProvider provider = (IBlockTemperatureProvider)owner.next();
                modifier = provider.getModifier(state, (BlockPos)pos, player);
                if (modifier == null) continue;
                if (modifier.affectedByDistance) {
                    modifier.setChange(modifier.getChange() * distanceMultiplier);
                    modifier.setPotency(modifier.getPotency() * distanceMultiplier);
                }
                modifiers.add(modifier);
            }
            if (!block.hasTileEntity(state)) continue;
            TileEntity tile = player.field_70170_p.func_175625_s((BlockPos)pos);
            if (tile instanceof ITileEntityTemperatureOwner) {
                ITileEntityTemperatureOwner owner2 = (ITileEntityTemperatureOwner)tile;
                modifier = owner2.getModifier(player);
                if (modifier == null) continue;
                if (modifier.affectedByDistance) {
                    modifier.setChange(modifier.getChange() * distanceMultiplier);
                    modifier.setPotency(modifier.getPotency() * distanceMultiplier);
                }
                modifiers.add(modifier);
                continue;
            }
            for (ITileEntityTemperatureProvider provider : TemperatureRegistry.TILE_ENTITIES) {
                TileEntityModifier modifier3 = provider.getModifier(tile, player);
                if (modifier3 == null) continue;
                modifier3.setChange(modifier3.getChange() * distanceMultiplier);
                modifier3.setPotency(modifier3.getPotency() * distanceMultiplier);
                modifiers.add(modifier3);
            }
        }
    }
}

