/*
 * Decompiled with CFR 0.152.
 */
package com.lumintorious.ambiental.modifiers;

import com.lumintorious.ambiental.TFCAmbientalConfig;
import com.lumintorious.ambiental.Util;
import com.lumintorious.ambiental.capability.TemperatureCapability;

public class BaseModifier {
    private String unlocalizedName;
    private float change = 0.0f;
    private float potency = 0.0f;
    private int count = 1;
    private float multiplier = 1.0f;

    public float getMultiplier() {
        return this.multiplier;
    }

    public void setMultiplier(float multiplier) {
        this.multiplier = multiplier;
    }

    public void addMultiplier(float multiplier) {
        this.setMultiplier(this.getMultiplier() * multiplier);
    }

    public float getChange() {
        return this.change * this.multiplier * (this.count == 1 ? 1.0f : TFCAmbientalConfig.GENERAL.diminishedModifierMultiplier);
    }

    public void setChange(float change) {
        this.change = change;
    }

    public float getPotency() {
        return this.potency * this.multiplier * (this.count == 1 ? 1.0f : TFCAmbientalConfig.GENERAL.diminishedModifierMultiplier);
    }

    public void setPotency(float potency) {
        this.potency = potency;
    }

    public void addCount() {
        ++this.count;
    }

    public void absorb(BaseModifier modifier) {
        if (this.count >= TFCAmbientalConfig.GENERAL.modifierCap) {
            return;
        }
        this.count += modifier.count;
        this.change += modifier.change;
        this.potency += modifier.potency;
        this.addMultiplier(modifier.getMultiplier());
    }

    public int getCount() {
        return this.count;
    }

    public String getUnlocalizedName() {
        return this.unlocalizedName;
    }

    public BaseModifier(String unlocalizedName) {
        this.unlocalizedName = unlocalizedName;
    }

    public BaseModifier(String unlocalizedName, float change, float potency) {
        this.unlocalizedName = unlocalizedName;
        this.change = change;
        this.potency = potency;
    }

    public String getDisplayName() {
        return Util.translate("tfcambiental.modifier." + this.unlocalizedName);
    }

    public void apply(TemperatureCapability temp) {
    }

    public void cancel(TemperatureCapability temp) {
    }
}

