/*
 * Decompiled with CFR 0.152.
 */
package com.lumintorious.ambiental.capability;

import com.lumintorious.ambiental.capability.ITemperatureCapability;
import net.dries007.tfc.util.calendar.CalendarTFC;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.event.GameRuleChangeEvent;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class TimeExtensionCapability<C>
implements ICapabilitySerializable<NBTTagCompound> {
    @CapabilityInject(value=TimeExtensionCapability.class)
    public static final Capability<ITemperatureCapability> CAPABILITY = null;
    public int extensionTicksLeft = -1;
    public boolean isExtending = false;
    public long savedTime = -1L;
    public World world;

    public TimeExtensionCapability(World world) {
        this.world = world;
    }

    public static void onSleep(PlayerWakeUpEvent event) {
        World world = event.getEntityLiving().field_70170_p;
        TimeExtensionCapability cap = (TimeExtensionCapability)world.getCapability(CAPABILITY, null);
        if (cap.isExtending) {
            world.func_72877_b((world.func_72820_D() / 24000L - 1L) * 24000L);
            CalendarTFC.INSTANCE.setTimeFromWorldTime(world.func_72820_D());
            cap.stopExtensionFully();
        }
    }

    public static void onGameRuleChange(GameRuleChangeEvent event) {
        WorldServer world = event.getServer().func_71218_a(0);
        TimeExtensionCapability cap = (TimeExtensionCapability)world.getCapability(CAPABILITY, null);
        int players = world.func_175661_b(EntityPlayer.class, x -> true).size();
        if (players == 0) {
            return;
        }
        if (event.getRuleName().equals("doDaylightCycle") && cap.getDaylightCycle() && cap.isExtending) {
            cap.stopExtension();
        }
    }

    public static void onWorldTick(TickEvent.WorldTickEvent event) {
    }

    public void tickDown() {
        --this.extensionTicksLeft;
        if (this.world.func_72820_D() != this.savedTime) {
            this.stopExtensionFully();
            this.world.func_72877_b(this.world.func_72820_D() - 2L);
            CalendarTFC.INSTANCE.setTimeFromWorldTime(this.world.func_72820_D());
        }
        if (this.extensionTicksLeft <= 0) {
            this.stopExtensionFully();
        }
    }

    public void startExtension(int ticksLeft) {
        this.extensionTicksLeft = ticksLeft;
        this.isExtending = true;
        this.savedTime = this.world.func_72820_D();
        this.setDaylightCycle(false);
        CalendarTFC.INSTANCE.setDoDaylightCycle();
    }

    public void stopExtension() {
        this.isExtending = false;
        this.extensionTicksLeft = -1;
        this.world.func_72877_b(this.world.func_72820_D() + 1L);
        CalendarTFC.INSTANCE.setTimeFromWorldTime(this.world.func_72820_D());
        CalendarTFC.INSTANCE.setDoDaylightCycle();
    }

    public void stopExtensionFully() {
        this.stopExtension();
        this.setDaylightCycle(true);
        CalendarTFC.INSTANCE.setDoDaylightCycle();
    }

    public void setDaylightCycle(boolean isOn) {
        this.world.func_82736_K().func_82764_b("doDaylightCycle", isOn ? "true" : "false");
    }

    public boolean getDaylightCycle() {
        return this.world.func_82736_K().func_82766_b("doDaylightCycle");
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74757_a("isExtending", this.isExtending);
        tag.func_74768_a("ticksLeft", this.extensionTicksLeft);
        tag.func_74772_a("savedTime", this.savedTime);
        return tag;
    }

    public void deserializeNBT(NBTTagCompound tag) {
        this.extensionTicksLeft = tag.func_74762_e("ticksLeft");
        this.savedTime = tag.func_74763_f("savedTime");
        this.isExtending = tag.func_74767_n("isExtending");
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability != null && capability == CAPABILITY;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        return (T)(capability == CAPABILITY ? this : null);
    }
}

