/*
 * Decompiled with CFR 0.152.
 */
package com.lumintorious.ambiental.capability;

import com.lumintorious.ambiental.AmbientalDamage;
import com.lumintorious.ambiental.TFCAmbientalConfig;
import com.lumintorious.ambiental.capability.ITemperatureCapability;
import com.lumintorious.ambiental.capability.TemperaturePacket;
import com.lumintorious.ambiental.modifiers.BaseModifier;
import com.lumintorious.ambiental.modifiers.BlockModifier;
import com.lumintorious.ambiental.modifiers.EnvironmentalModifier;
import com.lumintorious.ambiental.modifiers.EquipmentModifier;
import com.lumintorious.ambiental.modifiers.ItemModifier;
import com.lumintorious.ambiental.modifiers.ModifierStorage;
import net.dries007.tfc.TerraFirmaCraft;
import net.dries007.tfc.api.capability.food.FoodStatsTFC;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class TemperatureCapability<C>
implements ICapabilitySerializable<NBTTagCompound>,
ITemperatureCapability {
    @CapabilityInject(value=ITemperatureCapability.class)
    public static final Capability<ITemperatureCapability> CAPABILITY = null;
    private final EntityPlayer player;
    public static final BaseModifier CORE_TEMPERATURE = new BaseModifier("core", 0.0f, 0.0f);
    public boolean isRising;
    public static float AVERAGE = TFCAmbientalConfig.GENERAL.averageTemperature;
    public static float HOT_THRESHOLD = TFCAmbientalConfig.GENERAL.hotTemperature;
    public static float COOL_THRESHOLD = TFCAmbientalConfig.GENERAL.coldTemperature;
    public static float BURN_THRESHOLD = TFCAmbientalConfig.GENERAL.burningTemperature;
    public static float FREEZE_THRESHOLD = TFCAmbientalConfig.GENERAL.freezingTemperature;
    public ModifierStorage modifiers = new ModifierStorage();
    public float bodyTemperature = AVERAGE;
    public float savedTarget = AVERAGE;
    public static final float BAD_MULTIPLIER = 0.002f;
    public static final float GOOD_MULTIPLIER = 0.002f;
    public static final float CHANGE_CAP = 7.5f;
    public static final float HIGH_CHANGE = 0.2f;
    public float savedPotency = 1.0f;
    public int tick = 0;
    public int damageTick = 0;

    public TemperatureCapability(EntityPlayer player) {
        this.player = player;
    }

    public void clearModifiers() {
        this.modifiers = new ModifierStorage();
    }

    public void evaluateModifiers() {
        this.clearModifiers();
        ItemModifier.computeModifiers(this.player, this.modifiers);
        EnvironmentalModifier.computeModifiers(this.player, this.modifiers);
        BlockModifier.computeModifiers(this.player, this.modifiers);
        EquipmentModifier.getModifiers(this.player, this.modifiers);
        this.savedTarget = this.modifiers.getTargetTemperature();
        this.savedPotency = this.modifiers.getTotalPotency();
    }

    public float getTargetTemperature() {
        return this.savedTarget;
    }

    public float getPotency() {
        return this.savedPotency;
    }

    public float getTemperatureChange() {
        float target = this.getTargetTemperature();
        float speed = this.getPotency() * TFCAmbientalConfig.GENERAL.temperatureMultiplier;
        float change = Math.min(7.5f, Math.max(-7.5f, target - this.bodyTemperature));
        float newTemp = this.bodyTemperature + change;
        boolean isRising = true;
        speed = this.bodyTemperature < AVERAGE && newTemp > this.bodyTemperature || this.bodyTemperature > AVERAGE && newTemp < this.bodyTemperature ? (speed *= 0.002f * TFCAmbientalConfig.GENERAL.positiveModifier) : (speed *= 0.002f * TFCAmbientalConfig.GENERAL.negativeModifier);
        return change * speed;
    }

    public void say(Object string) {
        this.player.func_145747_a((ITextComponent)new TextComponentString(string.toString()));
    }

    public void update() {
        boolean server;
        boolean bl = server = !this.player.field_70170_p.field_72995_K;
        if (server) {
            this.setTemperature(this.getTemperature() + this.getTemperatureChange() / (float)TFCAmbientalConfig.GENERAL.tickInterval);
            if (this.tick <= TFCAmbientalConfig.GENERAL.tickInterval) {
                ++this.tick;
                return;
            }
            this.tick = 0;
            if (this.damageTick > 40) {
                this.damageTick = 0;
                if (TFCAmbientalConfig.GENERAL.takeDamage) {
                    if (this.getTemperature() > BURN_THRESHOLD) {
                        this.player.func_70097_a(AmbientalDamage.HEAT, 4.0f);
                    } else if (this.getTemperature() < FREEZE_THRESHOLD) {
                        this.player.func_70097_a(AmbientalDamage.COLD, 4.0f);
                    }
                }
                if (TFCAmbientalConfig.GENERAL.loseHungerThirst && this.player.func_71024_bL() instanceof FoodStatsTFC) {
                    FoodStatsTFC stats = (FoodStatsTFC)this.player.func_71024_bL();
                    if (this.getTemperature() > (HOT_THRESHOLD * 2.0f + BURN_THRESHOLD) / 3.0f) {
                        stats.addThirst(-8.0f);
                    } else if (this.getTemperature() < (COOL_THRESHOLD * 2.0f + FREEZE_THRESHOLD) / 3.0f) {
                        stats.func_75114_a(stats.func_75116_a() - 1);
                    }
                }
            } else {
                ++this.damageTick;
            }
            this.evaluateModifiers();
            this.updateAndSync();
        }
    }

    public String toString() {
        String str = "";
        for (BaseModifier modifier : this.modifiers) {
            str = str + modifier.getUnlocalizedName() + " -> " + modifier.getChange() + " @ " + modifier.getPotency() + "\n";
        }
        return String.format("Body: %.1f ( %.4f )\nTarget: %.1f \nPotency: %.4f", Float.valueOf(this.bodyTemperature), Float.valueOf(this.getTemperatureChange()), Float.valueOf(this.getTargetTemperature()), Float.valueOf(this.modifiers.getTotalPotency())) + "\n" + str;
    }

    @Override
    public float getTemperature() {
        return this.bodyTemperature;
    }

    @Override
    public void setTemperature(float newTemp) {
        this.isRising = !(newTemp < this.getTemperature());
        this.bodyTemperature = newTemp;
    }

    @Override
    public EntityPlayer getPlayer() {
        return this.player;
    }

    @Override
    public float getChange() {
        return this.getTemperatureChange();
    }

    @Override
    public float getChangeSpeed() {
        return this.getPotency();
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74776_a("temperature", this.getTemperature());
        tag.func_74776_a("target", this.getTargetTemperature());
        tag.func_74776_a("potency", this.getPotency());
        return tag;
    }

    public void deserializeNBT(NBTTagCompound tag) {
        if (tag.func_74764_b("temperature")) {
            this.setTemperature(tag.func_74760_g("temperature"));
            this.savedTarget = tag.func_74760_g("target");
            this.savedPotency = tag.func_74760_g("potency");
        } else {
            this.setTemperature(23.4f);
        }
    }

    public void updateAndSync() {
        EntityPlayer player = this.getPlayer();
        if (player instanceof EntityPlayerMP) {
            TerraFirmaCraft.getNetwork().sendTo((IMessage)new TemperaturePacket(this.serializeNBT()), (EntityPlayerMP)player);
        }
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability != null && capability == CAPABILITY;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        return (T)(capability == CAPABILITY ? this : null);
    }
}

