/*
 * Decompiled with CFR 0.152.
 */
package com.lumintorious.ambiental.api;

import com.lumintorious.ambiental.api.IBlockTemperatureProvider;
import com.lumintorious.ambiental.api.IEnvironmentalTemperatureProvider;
import com.lumintorious.ambiental.api.IItemTemperatureProvider;
import com.lumintorious.ambiental.api.ITemperatureProvider;
import com.lumintorious.ambiental.api.ITileEntityTemperatureProvider;
import com.lumintorious.ambiental.modifiers.BlockModifier;
import com.lumintorious.ambiental.modifiers.EnvironmentalModifier;
import com.lumintorious.ambiental.modifiers.TileEntityModifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import net.minecraft.init.Blocks;
import net.minecraft.world.EnumSkyBlock;

public class TemperatureRegistry<Type extends ITemperatureProvider>
implements Iterable<Type> {
    public static final TemperatureRegistry<IItemTemperatureProvider> ITEMS = new TemperatureRegistry();
    public static final TemperatureRegistry<IBlockTemperatureProvider> BLOCKS = new TemperatureRegistry();
    public static final TemperatureRegistry<ITileEntityTemperatureProvider> TILE_ENTITIES = new TemperatureRegistry();
    public static final TemperatureRegistry<IEnvironmentalTemperatureProvider> ENVIRONMENT = new TemperatureRegistry();
    private final ArrayList<Type> list = new ArrayList();
    private final HashMap<String, Type> map = new HashMap();

    private TemperatureRegistry() {
    }

    public void register(Type type) {
        this.list.add(type);
    }

    public boolean has(Type type) {
        return this.map.containsValue(type) || this.list.contains(type);
    }

    @Override
    public Iterator<Type> iterator() {
        return new Iterator<Type>(){
            private Iterator listIterator;
            {
                this.listIterator = TemperatureRegistry.this.list.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.listIterator.hasNext();
            }

            @Override
            public Type next() {
                return (ITemperatureProvider)this.listIterator.next();
            }
        };
    }

    static {
        TILE_ENTITIES.register(TileEntityModifier::handleCharcoalForge);
        TILE_ENTITIES.register(TileEntityModifier::handleFirePit);
        TILE_ENTITIES.register(TileEntityModifier::handleBloomery);
        TILE_ENTITIES.register(TileEntityModifier::handleLamps);
        BLOCKS.register((state, pos, player) -> state.func_177230_c() == Blocks.field_150480_ab ? new BlockModifier("fire", 3.0f, 3.0f) : null);
        BLOCKS.register((state, pos, player) -> state.func_177230_c() == Blocks.field_150353_l ? new BlockModifier("lava", 3.0f, 3.0f) : null);
        BLOCKS.register((state, pos, player) -> state.func_177230_c() == Blocks.field_150356_k ? new BlockModifier("lava", 3.0f, 3.0f) : null);
        BLOCKS.register((state, pos, player) -> state.func_177230_c() == Blocks.field_150431_aC && player.field_70170_p.func_175642_b(EnumSkyBlock.SKY, pos) == 15 ? new BlockModifier("snow", -1.5f, 0.2f, false) : null);
        ENVIRONMENT.register(EnvironmentalModifier::handleGeneralTemperature);
        ENVIRONMENT.register(EnvironmentalModifier::handleShade);
        ENVIRONMENT.register(EnvironmentalModifier::handleCozy);
        ENVIRONMENT.register(EnvironmentalModifier::handleThirst);
        ENVIRONMENT.register(EnvironmentalModifier::handleFood);
        ENVIRONMENT.register(EnvironmentalModifier::handleDiet);
        ENVIRONMENT.register(EnvironmentalModifier::handleFire);
        ENVIRONMENT.register(EnvironmentalModifier::handleWater);
        ENVIRONMENT.register(EnvironmentalModifier::handleRain);
        ENVIRONMENT.register(EnvironmentalModifier::handleSprinting);
        ENVIRONMENT.register(EnvironmentalModifier::handleUnderground);
        ENVIRONMENT.register(EnvironmentalModifier::handlePotionEffects);
    }
}

