/*
 * Decompiled with CFR 0.152.
 */
package com.lumintorious.ambiental;

import com.lumintorious.ambiental.capability.TemperatureCapability;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="tfcambiental", category="")
@Mod.EventBusSubscriber(modid="tfcambiental")
@Config.LangKey(value="config.tfcambiental")
public class TFCAmbientalConfig {
    @Config.Comment(value={"Client settings"})
    @Config.LangKey(value="config.tfcambiental.client")
    public static final ClientCFG CLIENT = new ClientCFG();
    @Config.Comment(value={"General settings"})
    @Config.LangKey(value="config.tfcambiental.general")
    public static final GeneralCFG GENERAL = new GeneralCFG();
    @Config.Comment(value={"Time extension settings"})
    @Config.LangKey(value="config.tfcambiental.time_extension")
    public static final TimeExtensionCFG TIME_EXTENSION = new TimeExtensionCFG();

    @SubscribeEvent
    public static void onConfigChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("tfcambiental")) {
            ConfigManager.sync((String)"tfcambiental", (Config.Type)Config.Type.INSTANCE);
            TemperatureCapability.AVERAGE = TFCAmbientalConfig.GENERAL.averageTemperature;
            TemperatureCapability.HOT_THRESHOLD = TFCAmbientalConfig.GENERAL.hotTemperature;
            TemperatureCapability.COOL_THRESHOLD = TFCAmbientalConfig.GENERAL.coldTemperature;
            TemperatureCapability.BURN_THRESHOLD = TFCAmbientalConfig.GENERAL.burningTemperature;
            TemperatureCapability.FREEZE_THRESHOLD = TFCAmbientalConfig.GENERAL.freezingTemperature;
        }
    }

    public static class GeneralCFG {
        @Config.Comment(value={"How quickly temperature rises and decreases. Default = 1.0"})
        @Config.LangKey(value="config.tfcambiental.general.temperatureMultiplier")
        public float temperatureMultiplier = 1.0f;
        @Config.Comment(value={"How fast does temperature change when it's going towards the average. Default = 5"})
        @Config.LangKey(value="config.tfcambiental.general.positiveModifier")
        public float positiveModifier = 5.0f;
        @Config.Comment(value={"How fast does temperature change when it's going away from the average. If you think you are giving yourself a challenge by increasing this number, think twice. It makes it so that you have to warm yourself up every so often. Default = 1"})
        @Config.LangKey(value="config.tfcambiental.general.negativeModifier")
        public float negativeModifier = 1.0f;
        @Config.Comment(value={"How many ticks between modifier calculations. Too high values help performance but behave weirdly. 20 = 1 second means modifiers are checked every second. Also affects the packet sending interval. Default = 20"})
        @Config.LangKey(value="config.tfcambiental.general.tickInterval")
        public int tickInterval = 20;
        @Config.Comment(value={"How potent are multipliers with more than one instance. (Eg. 2 fire pits nearby means they have 2 * this effectiveness). Default = 0.7"})
        @Config.LangKey(value="config.tfcambiental.general.diminishedModifierMultiplier")
        public float diminishedModifierMultiplier = 0.7f;
        @Config.Comment(value={"If true, you will start taking damage when below freezing or above burning temperatures. Default = true"})
        @Config.LangKey(value="config.tfcambiental.general.takeDamage")
        public boolean takeDamage = true;
        @Config.Comment(value={"If true, you will start losing hunger when below cold temperatures and losing thirst when above hot temperatures. Default = true"})
        @Config.LangKey(value="config.tfcambiental.general.loseHungerThirst")
        public boolean loseHungerThirst = true;
        @Config.Comment(value={"How many modifiers of the same type until they stop adding together. Default = 4"})
        @Config.LangKey(value="config.tfcambiental.general.modifierCap")
        public int modifierCap = 4;
        @Config.Comment(value={"If true, temperate areas won't be as mild. Default = true"})
        @Config.LangKey(value="config.tfcambiental.general.harsherTemperateAreas")
        public boolean harsherTemperateAreas = true;
        @Config.Comment(value={"If harsherTemperateAreas is true, environmental temperatures going away from the average are multiplied by this number. (The less temperate an area is, the less the modifier affects it). Default = 1.2 "})
        @Config.LangKey(value="config.tfcambiental.general.harsherMultiplier")
        public float harsherMultiplier = 1.2f;
        @Config.Comment(value={"The temperature at which you are at equilibrium. It's advisable to not change this by a lot since the entire ecosystem revolves around this. Default = 15"})
        @Config.LangKey(value="config.tfcambiental.general.averageTemperature")
        public float averageTemperature = 15.0f;
        @Config.Comment(value={"The temperature at which your screen starts heating. It's advisable to not change this by a lot since the entire ecosystem revolves around this. Default = 20"})
        @Config.LangKey(value="config.tfcambiental.general.hotTemperature")
        public float hotTemperature = 20.0f;
        @Config.Comment(value={"The temperature at which your screen starts freezing. It's advisable to not change this by a lot since the entire ecosystem revolves around this. Default = 10"})
        @Config.LangKey(value="config.tfcambiental.general.coldTemperature")
        public float coldTemperature = 10.0f;
        @Config.Comment(value={"The temperature at which you start burning and taking damage. It's advisable to not change this by a lot since the entire ecosystem revolves around this. Default = 25"})
        @Config.LangKey(value="config.tfcambiental.general.burningTemperature")
        public float burningTemperature = 25.0f;
        @Config.Comment(value={"The temperature at which you start freezing and taking damage. It's advisable to not change this by a lot since the entire ecosystem revolves around this. Default = 5"})
        @Config.LangKey(value="config.tfcambiental.general.freezingTemperature")
        public float freezingTemperature = 5.0f;
        @Config.Comment(value={"If true, holding a TFC debug wand in your hand prints modifier info to the chat"})
        @Config.LangKey(value="config.tfcambiental.general.enableDebug")
        public boolean enableDebug = false;
    }

    public static class ClientCFG {
        @Config.Comment(value={"If true, temperature is displayed in Celsius instead of Farhenheit ."})
        @Config.LangKey(value="config.tfcambiental.client.celsius")
        public boolean celsius = true;
        @Config.Comment(value={"If true, you will get extra details about your temperature when sneaking, when false they are always visible."})
        @Config.LangKey(value="config.tfcambiental.client.sneakyDetails")
        public boolean sneakyDetails = true;
    }

    public static class TimeExtensionCFG {
    }
}

