/*
 * Decompiled with CFR 0.152.
 */
package com.lumintorious.ambiental;

import com.lumintorious.ambiental.TFCAmbientalConfig;
import com.lumintorious.ambiental.capability.ITemperatureCapability;
import com.lumintorious.ambiental.capability.TemperatureCapability;
import java.awt.Color;
import net.dries007.tfc.objects.fluids.FluidsTFC;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiRenderer {
    public static final ResourceLocation COLD_VIGNETTE = new ResourceLocation("tfcambiental:textures/gui/cold_vignette.png");
    public static final ResourceLocation HOT_VIGNETTE = new ResourceLocation("tfcambiental:textures/gui/hot_vignette.png");
    public static final ResourceLocation MINUS = new ResourceLocation("tfcambiental:textures/gui/lower.png");
    public static final ResourceLocation PLUS = new ResourceLocation("tfcambiental:textures/gui/higher.png");
    public static final ResourceLocation MINUSER = new ResourceLocation("tfcambiental:textures/gui/lowerer.png");
    public static final ResourceLocation PLUSER = new ResourceLocation("tfcambiental:textures/gui/higherer.png");

    @SubscribeEvent
    public void onPostRenderOverlay(RenderGameOverlayEvent.Post event) {
    }

    @SubscribeEvent
    public void render(RenderGameOverlayEvent.Pre event) {
        IBlockState state;
        Block block;
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player.func_184812_l_() || player.field_70128_L || player.func_175149_v()) {
            return;
        }
        TemperatureCapability tempSystem = (TemperatureCapability)player.getCapability(TemperatureCapability.CAPABILITY, null);
        ScaledResolution resolution = event.getResolution();
        int width = resolution.func_78326_a();
        int height = resolution.func_78328_b();
        float redCol = 0.0f;
        float greenCol = 0.0f;
        float blueCol = 0.0f;
        float offsetY = 0.0f;
        float offsetX = 0.0f;
        float offsetYArrow = 0.0f;
        BlockPos pos = new BlockPos((Vec3i)player.func_180425_c());
        BlockPos pos2 = new BlockPos(pos.func_177958_n(), pos.func_177956_o() + 1, pos.func_177952_p());
        if (player.func_184218_aH()) {
            offsetY = -10.0f;
            offsetYArrow = -10.0f;
            offsetX = 0.0f;
        }
        if ((block = (state = player.field_70170_p.func_180495_p(pos2)).func_177230_c()) == FluidsTFC.HOT_WATER.get().getBlock() || block == FluidsTFC.SALT_WATER.get().getBlock() || block == FluidsTFC.FRESH_WATER.get().getBlock()) {
            offsetY = -10.0f;
            offsetX = 0.0f;
        }
        this.drawTemperatureVignettes(width, height, (EntityPlayer)player, event);
        if (event.getType() != RenderGameOverlayEvent.ElementType.HOTBAR) {
            return;
        }
        float temperature = 1.0f;
        ScaledResolution sr = event.getResolution();
        int healthRowHeight = sr.func_78328_b() - 40;
        int armorRowHeight = healthRowHeight - 10;
        int mid = sr.func_78326_a() / 2;
        temperature = tempSystem.getTemperature();
        GL11.glEnable((int)3042);
        if (temperature > TemperatureCapability.AVERAGE) {
            float hotRange = TemperatureCapability.HOT_THRESHOLD - TemperatureCapability.AVERAGE + 2.0f;
            float red = Math.max(0.0f, Math.min(1.0f, (temperature - TemperatureCapability.AVERAGE) / hotRange));
            redCol = 1.0f;
            greenCol = 1.0f - red / 2.4f;
            blueCol = 1.0f - red / 1.6f;
        } else {
            float coolRange = TemperatureCapability.AVERAGE - TemperatureCapability.COOL_THRESHOLD - 2.0f;
            float blue = Math.max(0.0f, Math.min(1.0f, (TemperatureCapability.AVERAGE - temperature) / coolRange));
            redCol = 1.0f - blue / 1.6f;
            greenCol = 1.0f - blue / 2.4f;
            blueCol = 1.0f;
        }
        GL11.glColor4f((float)redCol, (float)greenCol, (float)blueCol, (float)0.9f);
        Color c = new Color(redCol, greenCol, blueCol, 1.0f);
        GL11.glColor4f((float)redCol, (float)greenCol, (float)blueCol, (float)0.9f);
        GL11.glEnable((int)3042);
        float speed = tempSystem.getChangeSpeed();
        float change = tempSystem.getChange();
        if (change > 0.0f) {
            if (change > 0.2f) {
                GuiRenderer.drawTexturedModalRect(mid - 8, (float)(armorRowHeight - 4) + offsetYArrow, 16.0f, 16.0f, PLUSER);
            } else {
                GuiRenderer.drawTexturedModalRect(mid - 8, (float)(armorRowHeight - 4) + offsetYArrow, 16.0f, 16.0f, PLUS);
            }
        } else if (change < -0.2f) {
            GuiRenderer.drawTexturedModalRect(mid - 8, (float)(armorRowHeight - 4) + offsetYArrow, 16.0f, 16.0f, MINUSER);
        } else {
            GuiRenderer.drawTexturedModalRect(mid - 8, (float)(armorRowHeight - 4) + offsetYArrow, 16.0f, 16.0f, MINUS);
        }
        if ((player.func_70093_af() || !TFCAmbientalConfig.CLIENT.sneakyDetails) && tempSystem instanceof TemperatureCapability) {
            TemperatureCapability sys = tempSystem;
            float targetFormatted = sys.getTargetTemperature();
            float tempFormatted = sys.getTemperature();
            float changeFormatted = sys.getChange();
            if (!TFCAmbientalConfig.CLIENT.celsius) {
                targetFormatted = targetFormatted * 1.0f + 32.0f;
                tempFormatted = tempFormatted * 1.0f + 32.0f;
                changeFormatted *= 1.0f;
            }
            FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
            String tempStr = String.format("%.1f\u00ba -> %.1f\u00ba", Float.valueOf(temperature), Float.valueOf(targetFormatted));
            String changeStr = String.format("%.3f\u00ba/s", Float.valueOf(change));
            fr.func_175063_a(tempStr, (float)(mid + 50 - fr.func_78256_a(tempStr) / 2) + offsetX, (float)(armorRowHeight + 1) + offsetY, c.getRGB());
            fr.func_175063_a(changeStr, (float)(mid - 50 - fr.func_78256_a(changeStr) / 2), (float)(armorRowHeight + 1), c.getRGB());
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.9f);
        GL11.glDisable((int)3042);
    }

    private static void drawTexturedModalRect(float x, float y, float width, float height, ResourceLocation loc) {
        Minecraft minecraft = Minecraft.func_71410_x();
        minecraft.func_110434_K().func_110577_a(loc);
        GlStateManager.func_179097_i();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179118_c();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_181662_b((double)x, (double)(y + height), -90.0).func_187315_a(0.0, 1.0).func_181675_d();
        buffer.func_181662_b((double)(x + width), (double)(y + height), -90.0).func_187315_a(1.0, 1.0).func_181675_d();
        buffer.func_181662_b((double)(x + width), (double)y, -90.0).func_187315_a(1.0, 0.0).func_181675_d();
        buffer.func_181662_b((double)x, (double)y, -90.0).func_187315_a(0.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179126_j();
        GlStateManager.func_179141_d();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void drawTemperatureVignettes(int width, int height, EntityPlayer player, RenderGameOverlayEvent.Pre event) {
        ResourceLocation vignetteLocation = null;
        float temperature = 1.0f;
        ITemperatureCapability tempSystem = (ITemperatureCapability)player.getCapability(TemperatureCapability.CAPABILITY, null);
        temperature = tempSystem.getTemperature();
        float opacity = 1.0f;
        if (temperature > TemperatureCapability.HOT_THRESHOLD) {
            vignetteLocation = HOT_VIGNETTE;
            opacity = Math.min(0.95f, (temperature - TemperatureCapability.HOT_THRESHOLD) / 14.0f);
        } else if (temperature < TemperatureCapability.COOL_THRESHOLD) {
            vignetteLocation = COLD_VIGNETTE;
            opacity = Math.min(0.95f, (TemperatureCapability.COOL_THRESHOLD - temperature) / 14.0f);
        }
        if (event.getType() == RenderGameOverlayEvent.ElementType.PORTAL && vignetteLocation != null) {
            Minecraft minecraft = Minecraft.func_71410_x();
            minecraft.func_110434_K().func_110577_a(vignetteLocation);
            GlStateManager.func_179097_i();
            GlStateManager.func_179132_a((boolean)false);
            GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)opacity);
            GlStateManager.func_179118_c();
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder buffer = tessellator.func_178180_c();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            buffer.func_181662_b(0.0, (double)height, -90.0).func_187315_a(0.0, 1.0).func_181675_d();
            buffer.func_181662_b((double)width, (double)height, -90.0).func_187315_a(1.0, 1.0).func_181675_d();
            buffer.func_181662_b((double)width, 0.0, -90.0).func_187315_a(1.0, 0.0).func_181675_d();
            buffer.func_181662_b(0.0, 0.0, -90.0).func_187315_a(0.0, 0.0).func_181675_d();
            tessellator.func_78381_a();
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179126_j();
            GlStateManager.func_179141_d();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }
}

