/*
 * Decompiled with CFR 0.152.
 */
package com.lumintorious.ambiental;

import com.lumintorious.ambiental.capability.TemperatureCapability;
import com.lumintorious.ambiental.effects.TempEffect;
import java.lang.reflect.Field;
import net.dries007.tfc.api.capability.food.CapabilityFood;
import net.dries007.tfc.api.capability.food.IFood;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class AmbientalHandler {
    @SubscribeEvent
    public void onInteract(PlayerInteractEvent.EntityInteractSpecific event) {
        Entity entity = event.getTarget();
        EntityPlayer player = event.getEntityPlayer();
        if (entity instanceof EntityVillager) {
            EntityVillager villager = (EntityVillager)entity;
            long time = villager.field_70170_p.func_72820_D();
            try {
                MerchantRecipeList list = new MerchantRecipeList();
                for (Field f : EntityVillager.class.getDeclaredFields()) {
                    f.setAccessible(true);
                    if (!(f.get(villager) instanceof MerchantRecipeList)) continue;
                    list = (MerchantRecipeList)f.get(villager);
                    MerchantRecipeList list2 = new MerchantRecipeList();
                    for (MerchantRecipe recipe : list) {
                        ItemStack itemToBuy = recipe.func_77394_a().func_77946_l();
                        ItemStack itemToBuy2 = recipe.func_77396_b().func_77946_l();
                        ItemStack itemToSell = recipe.func_77397_d().func_77946_l();
                        if (itemToSell.hasCapability(CapabilityFood.CAPABILITY, null)) {
                            IFood cap = (IFood)itemToSell.getCapability(CapabilityFood.CAPABILITY, null);
                            cap.setCreationDate(time);
                        }
                        list2.add((Object)new MerchantRecipe(itemToBuy, itemToBuy2, itemToSell));
                    }
                    f.set(villager, list2);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @SubscribeEvent
    public void onPlayerDeath(LivingDeathEvent event) {
        if (event.getEntityLiving().field_70170_p.field_72995_K) {
            return;
        }
        if (!(event.getEntityLiving() instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.getEntityLiving();
        if (player.hasCapability(TemperatureCapability.CAPABILITY, null)) {
            TemperatureCapability cap = (TemperatureCapability)player.getCapability(TemperatureCapability.CAPABILITY, null);
            cap.bodyTemperature = TemperatureCapability.AVERAGE;
        }
    }

    @SubscribeEvent
    public void onPlayerSpawn(LivingSpawnEvent event) {
        if (event.getEntityLiving().field_70170_p.field_72995_K) {
            return;
        }
        if (!(event.getEntityLiving() instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.getEntityLiving();
        player.func_145747_a((ITextComponent)new TextComponentString("respawned"));
    }

    @SubscribeEvent
    public void onAttachEntityCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getObject();
            ResourceLocation loc = new ResourceLocation("tfcambiental", "temperature");
            if (!event.getCapabilities().containsKey(loc)) {
                event.addCapability(loc, new TemperatureCapability(player));
            }
        }
    }

    @SubscribeEvent
    public void onPlayerUpdate(LivingEvent.LivingUpdateEvent event) {
        if (!(event.getEntityLiving() instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.getEntityLiving();
        if (player.func_184812_l_()) {
            return;
        }
        TemperatureCapability temp = (TemperatureCapability)player.getCapability(TemperatureCapability.CAPABILITY, null);
        ItemStack stack = player.func_184582_a(EntityEquipmentSlot.MAINHAND);
        if (stack != null && !player.field_70170_p.field_72995_K && stack.func_77973_b().getRegistryName().toString().equals("tfc:wand")) {
            temp.say(temp);
        }
        temp.update();
    }

    @SubscribeEvent
    public void registerPotions(RegistryEvent.Register<Potion> event) {
        event.getRegistry().register((IForgeRegistryEntry)TempEffect.WARM);
        event.getRegistry().register((IForgeRegistryEntry)TempEffect.COOL);
    }
}

