/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.common.multiblock;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.ResourceLocation;
import vazkii.patchouli.api.VariableHolder;
import vazkii.patchouli.common.multiblock.Multiblock;
import vazkii.patchouli.common.multiblock.StateMatcher;

public class SerializedMultiblock {
    public String[][] pattern = new String[0][0];
    @VariableHolder
    public Map<String, String> mapping = new HashMap<String, String>();
    boolean symmetrical = false;
    int[] offset = new int[]{0, 0, 0};

    public Multiblock toMultiblock() {
        String allowed = "0_ ";
        String[][] stringArray = this.pattern;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String[] line;
            for (String s : line = stringArray[i]) {
                for (char c : s.toCharArray()) {
                    if ("0_ ".indexOf(c) != -1 || this.mapping.containsKey(String.valueOf(c))) continue;
                    throw new IllegalArgumentException("Character " + c + " in multiblock isn't mapped to a block");
                }
            }
        }
        Object[] targets = new Object[this.mapping.size() * 2];
        int i = 0;
        for (Map.Entry<String, String> e : this.mapping.entrySet()) {
            String key = e.getKey();
            String value = e.getValue();
            if (key.length() != 1) {
                throw new IllegalArgumentException(key + " is an invalid mapping key, every mapping key must be 1 character long");
            }
            char keyChar = key.charAt(0);
            StateMatcher matcher = this.getStateMatcher(value);
            if (matcher == null) {
                throw new IllegalArgumentException(value + " could not be resolved into a proper state for mapping '" + keyChar + "'");
            }
            targets[i] = Character.valueOf(keyChar);
            targets[i + 1] = matcher;
            i += 2;
        }
        Multiblock mb = new Multiblock(this.pattern, targets);
        mb.setSymmetrical(this.symmetrical);
        mb.offset(this.offset[0], this.offset[1], this.offset[2]);
        return mb;
    }

    private StateMatcher getStateMatcher(String s) {
        if ((s = s.trim()).equals("ANY")) {
            return StateMatcher.ANY;
        }
        if (s.equals("AIR")) {
            return StateMatcher.AIR;
        }
        String[] split = s.split("\\[");
        Block block = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(split[0]));
        if (block != null) {
            if (split.length > 1) {
                IBlockState state = block.func_176223_P();
                block0: for (String part : split[1].replace("]", "").split(",")) {
                    String[] keyValue = part.split("=");
                    for (IProperty prop : state.func_177228_b().keySet()) {
                        IBlockState changed = this.findProperty(state, prop, keyValue[0], keyValue[1]);
                        if (changed == null) continue;
                        state = changed;
                        continue block0;
                    }
                }
                return StateMatcher.fromState(state);
            }
            return StateMatcher.fromBlockLoose(block);
        }
        return null;
    }

    private <T extends Comparable<T>> IBlockState findProperty(IBlockState state, IProperty<T> prop, String key, String newValue) {
        if (key.equals(prop.func_177701_a())) {
            for (Comparable value : prop.func_177700_c()) {
                if (!prop.func_177702_a(value).equals(newValue)) continue;
                return state.func_177226_a(prop, value);
            }
        }
        return null;
    }
}

