/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book.page;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.gui.GuiBook;
import vazkii.patchouli.client.book.gui.GuiBookEntry;
import vazkii.patchouli.client.book.gui.button.GuiButtonEntry;
import vazkii.patchouli.client.book.page.abstr.PageWithText;

public class PageRelations
extends PageWithText {
    List<String> entries;
    String title;
    transient List<BookEntry> entryObjs;

    @Override
    public void build(BookEntry entry, int pageNum) {
        super.build(entry, pageNum);
        this.entryObjs = this.entries.stream().map(s -> s.contains(":") ? new ResourceLocation(s) : new ResourceLocation(this.book.getModNamespace(), s)).map(res -> this.book.contents.entries.get(res)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public void onDisplayed(GuiBookEntry parent, int left, int top) {
        super.onDisplayed(parent, left, top);
        ArrayList<BookEntry> displayedEntries = new ArrayList<BookEntry>(this.entryObjs);
        displayedEntries.removeIf(BookEntry::shouldHide);
        Collections.sort(displayedEntries);
        for (int i = 0; i < displayedEntries.size(); ++i) {
            GuiButtonEntry button = new GuiButtonEntry(parent, 0, 20 + i * 11, (BookEntry)displayedEntries.get(i), i);
            this.addButton(button);
        }
    }

    @Override
    protected void onButtonClicked(GuiButton button) {
        if (button instanceof GuiButtonEntry) {
            GuiBookEntry.displayOrBookmark(this.parent, ((GuiButtonEntry)button).getEntry());
        }
    }

    @Override
    public void render(int mouseX, int mouseY, float pticks) {
        this.parent.drawCenteredStringNoShadow(this.title == null || this.title.isEmpty() ? I18n.func_135052_a((String)"patchouli.gui.lexicon.relations", (Object[])new Object[0]) : this.title, 58, 0, this.book.headerColor);
        GuiBook.drawSeparator(this.book, 0, 12);
        super.render(mouseX, mouseY, pticks);
    }

    @Override
    public int getTextHeight() {
        return 22 + this.entryObjs.size() * 11;
    }
}

