/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.client.themes;

import betterquesting.api.utils.JsonHelper;
import betterquesting.api2.client.gui.resources.colors.IGuiColor;
import betterquesting.api2.client.gui.resources.lines.IGuiLine;
import betterquesting.api2.client.gui.resources.textures.IGuiTexture;
import betterquesting.api2.client.gui.themes.GuiKey;
import betterquesting.api2.client.gui.themes.IGuiTheme;
import betterquesting.client.themes.ResourceRegistry;
import betterquesting.client.themes.ThemeRegistry;
import betterquesting.core.BetterQuesting;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.ResourceLocation;

public class ResourceTheme
implements IGuiTheme {
    private final ResourceLocation ID;
    private final String dispName;
    private IGuiTheme parentTheme;
    private ResourceLocation parentID;
    private boolean cached = false;
    private final HashMap<ResourceLocation, IGuiTexture> TEX_MAP = new HashMap();
    private final HashMap<ResourceLocation, IGuiColor> COLOR_MAP = new HashMap();
    private final HashMap<ResourceLocation, IGuiLine> LINE_MAP = new HashMap();

    public ResourceTheme(ResourceLocation parentID, ResourceLocation id, String dispName) {
        this.ID = id;
        this.dispName = dispName;
        this.parentID = parentID;
    }

    public void loadFromJson(JsonObject jThm) {
        JsonObject jsonTextureRoot = JsonHelper.GetObject(jThm, "textures");
        for (Object entry : jsonTextureRoot.entrySet()) {
            if (!((JsonElement)entry.getValue()).isJsonObject()) continue;
            JsonObject joTex = ((JsonElement)entry.getValue()).getAsJsonObject();
            ResourceLocation typeID = new ResourceLocation(JsonHelper.GetString(joTex, "textureType", ""));
            IGuiTexture gTex = ResourceRegistry.INSTANCE.getTexReg().createNew(typeID, joTex);
            if (gTex == null) {
                BetterQuesting.logger.error("Failed to load texture type " + typeID + " for theme " + this.ID);
                continue;
            }
            this.setTexture(new ResourceLocation((String)entry.getKey()), gTex);
        }
        JsonObject jsonColourRoot = JsonHelper.GetObject(jThm, "colors");
        for (Map.Entry entry : jsonColourRoot.entrySet()) {
            if (!(entry.getValue() instanceof JsonObject)) continue;
            JsonObject joCol = ((JsonElement)entry.getValue()).getAsJsonObject();
            ResourceLocation typeID = new ResourceLocation(JsonHelper.GetString(joCol, "colorType", ""));
            IGuiColor gCol = ResourceRegistry.INSTANCE.getColorReg().createNew(typeID, joCol);
            if (gCol == null) {
                BetterQuesting.logger.error("Failed to load color type " + typeID + " for theme " + this.ID);
                continue;
            }
            this.setColor(new ResourceLocation((String)entry.getKey()), gCol);
        }
        JsonObject jsonLinesRoot = JsonHelper.GetObject(jThm, "lines");
        for (Map.Entry entry : jsonLinesRoot.entrySet()) {
            if (!(entry.getValue() instanceof JsonObject)) continue;
            JsonObject joLine = ((JsonElement)entry.getValue()).getAsJsonObject();
            ResourceLocation typeID = new ResourceLocation(JsonHelper.GetString(joLine, "lineType", ""));
            IGuiLine gLine = ResourceRegistry.INSTANCE.getLineReg().createNew(typeID, joLine);
            if (gLine == null) {
                BetterQuesting.logger.error("Failed to load line type " + typeID + " for theme " + this.ID);
                continue;
            }
            this.setLine(new ResourceLocation((String)entry.getKey()), gLine);
        }
    }

    private IGuiTheme getParent() {
        IGuiTheme parent;
        if (this.cached) {
            return this.parentTheme;
        }
        IGuiTheme checking = parent = ThemeRegistry.INSTANCE.getTheme(this.parentID);
        while (checking != null && checking instanceof ResourceTheme) {
            if (((ResourceTheme)checking).parentTheme == this) {
                BetterQuesting.logger.error("Circular reference in resource theme " + this.ID);
                this.parentTheme = null;
                this.cached = true;
                return null;
            }
            checking = ((ResourceTheme)checking).parentTheme;
        }
        this.parentTheme = parent;
        this.cached = true;
        return this.parentTheme;
    }

    public void setTexture(ResourceLocation key, IGuiTexture texture) {
        if (key == null) {
            return;
        }
        this.TEX_MAP.put(key, texture);
    }

    public void setColor(ResourceLocation key, IGuiColor color) {
        if (key == null) {
            return;
        }
        this.COLOR_MAP.put(key, color);
    }

    public void setLine(ResourceLocation key, IGuiLine line) {
        if (key == null) {
            return;
        }
        this.LINE_MAP.put(key, line);
    }

    @Override
    public String getName() {
        return this.dispName;
    }

    @Override
    public ResourceLocation getID() {
        return this.ID;
    }

    @Override
    public IGuiTexture getTexture(ResourceLocation key) {
        IGuiTexture value = this.TEX_MAP.get(key);
        if (value != null) {
            return value;
        }
        if (this.getParent() != null) {
            return this.getParent().getTexture(key);
        }
        return null;
    }

    @Override
    public IGuiLine getLine(ResourceLocation key) {
        IGuiLine value = this.LINE_MAP.get(key);
        if (value != null) {
            return value;
        }
        if (this.getParent() != null) {
            return this.getParent().getLine(key);
        }
        return null;
    }

    @Override
    public IGuiColor getColor(ResourceLocation key) {
        IGuiColor value = this.COLOR_MAP.get(key);
        if (value != null) {
            return value;
        }
        if (this.getParent() != null) {
            return this.getParent().getColor(key);
        }
        return null;
    }

    @Override
    @Nullable
    public <T> Function<T, GuiScreen> getGui(GuiKey<T> key) {
        return null;
    }
}

