/*
 * Decompiled with CFR 0.152.
 */
package justenoughpetroleum;

import com.google.common.collect.Lists;
import flaxbeard.immersivepetroleum.api.crafting.DistillationRecipe;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;

public class DistillationWrapper
implements IRecipeWrapper {
    public static final float INVALID_CHANCE = -1.0f;
    public DistillationRecipe recipe;

    public DistillationWrapper(DistillationRecipe recipe) {
        this.recipe = recipe;
    }

    public int getEnergyPerTick() {
        return this.recipe.getTotalProcessEnergy() / this.recipe.getTotalProcessTime();
    }

    public int getTime() {
        return this.recipe.getTotalProcessTime();
    }

    public FluidStack getInput() {
        return this.recipe.input.copy();
    }

    public List<FluidStack> getFluidOutputs() {
        return Lists.newArrayList((Object[])this.recipe.fluidOutput);
    }

    public List<ItemStack> getOutputs() {
        return IntStream.range(0, this.recipe.itemOutput.length).mapToObj(i -> this.markChance(this.recipe.itemOutput[i], this.getChance(i))).collect(Collectors.toList());
    }

    private float getChance(int i) {
        return i < this.recipe.chances.length ? this.recipe.chances[i] : -1.0f;
    }

    private ItemStack markChance(ItemStack stack, float chance) {
        stack = stack.func_77946_l();
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74776_a("chance", chance);
        stack.func_77982_d(compound);
        return stack;
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
    }

    private void drawShadowed(Minecraft minecraft, int foregroundcolor, int backgroundcolor, int drawoffsetX, int drawoffsetY, String costString) {
        minecraft.field_71466_p.func_78276_b(costString, drawoffsetX, drawoffsetY + 1, backgroundcolor);
        minecraft.field_71466_p.func_78276_b(costString, drawoffsetX + 1, drawoffsetY + 1, backgroundcolor);
        minecraft.field_71466_p.func_78276_b(costString, drawoffsetX + 1, drawoffsetY + 1, backgroundcolor);
        minecraft.field_71466_p.func_78276_b(costString, drawoffsetX, drawoffsetY, foregroundcolor);
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setOutputs(ItemStack.class, this.getOutputs());
        ingredients.setOutputs(FluidStack.class, this.getFluidOutputs());
        ingredients.setInput(FluidStack.class, (Object)this.getInput());
    }
}

