/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.network;

import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import mcjty.lib.network.ICommandHandler;
import mcjty.lib.network.NetworkTools;
import mcjty.lib.network.TypedMapTools;
import mcjty.lib.thirteen.Context;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.Logging;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PacketServerCommandTyped
implements IMessage {
    protected BlockPos pos;
    protected Integer dimensionId;
    protected String command;
    protected TypedMap params;

    public PacketServerCommandTyped() {
    }

    public PacketServerCommandTyped(ByteBuf buf) {
        this.fromBytes(buf);
    }

    public PacketServerCommandTyped(BlockPos pos, String command, TypedMap params) {
        this.pos = pos;
        this.command = command;
        this.params = params;
        this.dimensionId = null;
    }

    public PacketServerCommandTyped(BlockPos pos, Integer dimensionId, String command, TypedMap params) {
        this.pos = pos;
        this.command = command;
        this.params = params;
        this.dimensionId = dimensionId;
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = NetworkTools.readPos(buf);
        this.command = NetworkTools.readString(buf);
        this.params = TypedMapTools.readArguments(buf);
        this.dimensionId = buf.readBoolean() ? Integer.valueOf(buf.readInt()) : null;
    }

    public void toBytes(ByteBuf buf) {
        NetworkTools.writePos(buf, this.pos);
        NetworkTools.writeString(buf, this.command);
        TypedMapTools.writeArguments(buf, this.params);
        if (this.dimensionId != null) {
            buf.writeBoolean(true);
            buf.writeInt(this.dimensionId.intValue());
        } else {
            buf.writeBoolean(false);
        }
    }

    public void handle(Supplier<Context> supplier) {
        Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            EntityPlayerMP playerEntity = ctx.getSender();
            Object world = this.dimensionId == null ? playerEntity.func_130014_f_() : DimensionManager.getWorld((int)this.dimensionId);
            if (world == null) {
                return;
            }
            TileEntity te = world.func_175625_s(this.pos);
            if (!(te instanceof ICommandHandler)) {
                Logging.log("createStartScanPacket: TileEntity is not a CommandHandler!");
                return;
            }
            ICommandHandler commandHandler = (ICommandHandler)te;
            if (!commandHandler.execute(playerEntity, this.command, this.params)) {
                Logging.log("Command " + this.command + " was not handled!");
            }
        });
        ctx.setPacketHandled(true);
    }
}

