/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.multipart;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import mcjty.lib.multipart.MultipartBlock;
import mcjty.lib.multipart.MultipartTE;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;

public class MultipartBakedModel
implements IBakedModel {
    public static final ModelResourceLocation MODEL = new ModelResourceLocation("mcjtylib_ng:multipart");
    private TextureAtlasSprite particleTexture;

    public MultipartBakedModel(TextureAtlasSprite particleTexture) {
        this.particleTexture = particleTexture;
    }

    public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
        if (state == null) {
            return Collections.emptyList();
        }
        IExtendedBlockState extendedBlockState = (IExtendedBlockState)state;
        Map parts = (Map)extendedBlockState.getValue((IUnlistedProperty)MultipartBlock.PARTS);
        if (parts != null) {
            ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
            BlockRenderLayer layer = MinecraftForgeClient.getRenderLayer();
            for (Map.Entry entry : parts.entrySet()) {
                MultipartTE.Part part = (MultipartTE.Part)entry.getValue();
                IBlockState blockState = part.getState();
                if (layer != null && !blockState.func_177230_c().canRenderInLayer(blockState, layer)) continue;
                IBakedModel model = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178125_b(blockState);
                try {
                    if (model instanceof MultipartBakedModel) continue;
                    quads.addAll(model.func_188616_a(state, side, rand++));
                }
                catch (Exception ignore) {
                    System.out.println("MultipartBakedModel.getQuads");
                }
            }
            return quads;
        }
        return Collections.emptyList();
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return false;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.particleTexture;
    }

    public ItemCameraTransforms func_177552_f() {
        return ItemCameraTransforms.field_178357_a;
    }

    public ItemOverrideList func_188617_f() {
        return ItemOverrideList.field_188022_a;
    }
}

