/*
 * Decompiled with CFR 0.152.
 */
package scavenge.world.blockEffects;

import com.google.gson.JsonObject;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import scavenge.api.autodoc.BooleanElement;
import scavenge.api.autodoc.FloatElement;
import scavenge.api.autodoc.MapElement;
import scavenge.api.block.EffectContainer;
import scavenge.api.block.IResourceEffect;
import scavenge.api.block.IResourceFactory;
import scavenge.api.block.IResourceProperty;
import scavenge.api.block.impl.BaseResourceFactory;
import scavenge.api.block.impl.BaseResourceProperty;
import scavenge.api.utils.JsonUtil;

public class PropSpawnExplosion
extends BaseResourceProperty
implements IResourceEffect {
    float power;
    boolean flame;
    boolean smoking;

    public PropSpawnExplosion(JsonObject obj) {
        super(obj, "spawn_explosion");
        this.power = obj.get("power").getAsFloat();
        this.flame = JsonUtil.getOrDefault(obj, "flame", false);
        this.smoking = JsonUtil.getOrDefault(obj, "smoking", true);
        this.setJEIInfo("Spawns a Explosion with the Power of " + this.power);
    }

    @Override
    public boolean applyEffects(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean left, EnumFacing side, String resourceID, EffectContainer container) {
        world.func_72885_a(null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, this.power, this.flame, this.smoking);
        return false;
    }

    public static class SpawnExplosionFactory
    extends BaseResourceFactory {
        public SpawnExplosionFactory() {
            super("spawn_explosion", IResourceFactory.PropertyType.Effect);
        }

        @Override
        public IResourceProperty createObject(JsonObject obj) {
            return new PropSpawnExplosion(obj);
        }

        @Override
        public void addExample(JsonObject obj) {
            obj.addProperty("power", (Number)Float.valueOf(4.0f));
        }

        @Override
        public MapElement getDocumentation() {
            MapElement map = super.getDocumentation();
            map.setDescription("Spawns a Explosion at the Blocks Position");
            map.addElement(new FloatElement("power", 0.0f).setDescription("How Powerful the Explosion should be"));
            map.addElement(new BooleanElement("flame", false, "If the Explosion should spawn Flames"));
            map.addElement(new BooleanElement("smoking", true, "If the Explosion should spawn Smoke Particals"));
            return map;
        }
    }
}

