/*
 * Decompiled with CFR 0.152.
 */
package scavenge.world.blockConditions;

import com.google.gson.JsonObject;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import scavenge.api.autodoc.BooleanElement;
import scavenge.api.autodoc.MapElement;
import scavenge.api.autodoc.TextElement;
import scavenge.api.block.IResourceCondition;
import scavenge.api.block.IResourceFactory;
import scavenge.api.block.IResourceProperty;
import scavenge.api.block.impl.BaseResourceFactory;
import scavenge.api.block.impl.BaseResourceProperty;
import scavenge.api.utils.CompatState;
import scavenge.api.utils.JsonUtil;

public class PropRequireWeather
extends BaseResourceProperty
implements IResourceCondition {
    boolean requirePos;
    boolean defaultState;
    int requestedState;

    public PropRequireWeather(JsonObject obj) {
        super(obj, "require_weather");
        this.addSelfIncompat();
        this.requestedState = this.makeState(obj.get("weather").getAsString());
        this.defaultState = JsonUtil.getOrDefault(obj, "required", true);
        this.requirePos = JsonUtil.getOrDefault(obj, "directly", false);
    }

    @Override
    public boolean canCombine(IResourceProperty property) {
        return !(property instanceof PropRequireWeather);
    }

    private int makeState(String type) {
        if (type.equalsIgnoreCase("rain")) {
            return 1;
        }
        if (type.equalsIgnoreCase("thunder")) {
            return 2;
        }
        if (type.equalsIgnoreCase("snowing")) {
            return 3;
        }
        return 0;
    }

    private String makeTextState(int type) {
        if (type == 1) {
            return "Running";
        }
        if (type == 2) {
            return "ThunderStrom";
        }
        if (type == 3) {
            return "Snowing";
        }
        return "Sunny";
    }

    @Override
    public boolean canInteract(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean leftClick, EnumFacing side, String resourceID, boolean client) {
        if (this.defaultState) {
            return this.requestedState == this.getState(world, pos);
        }
        return this.requestedState != this.getState(world, pos);
    }

    private int getState(World world, BlockPos pos) {
        if (world.func_72896_J()) {
            if (this.requirePos) {
                if (world.func_180494_b(pos).func_76746_c()) {
                    return this.isSnowingAt(world, pos) ? 3 : 0;
                }
                if (world.func_175727_C(pos)) {
                    if (world.func_72911_I() && this.requestedState != 1) {
                        return 2;
                    }
                    return 1;
                }
            } else {
                if (world.func_180494_b(pos).func_76746_c()) {
                    return 3;
                }
                if (world.func_72911_I() && this.requestedState != 1) {
                    return 2;
                }
                return 1;
            }
        }
        return 0;
    }

    private boolean isSnowingAt(World world, BlockPos pos) {
        if (!world.func_175678_i(pos) || world.func_175725_q(pos).func_177956_o() > pos.func_177956_o()) {
            return false;
        }
        return world.func_175708_f(pos, false);
    }

    public static class WeatherFactory
    extends BaseResourceFactory {
        public WeatherFactory() {
            super("require_weather", IResourceFactory.PropertyType.Condition);
            this.setCompatState(CompatState.INCOMPATIBLE);
        }

        @Override
        public IResourceProperty createObject(JsonObject obj) {
            return new PropRequireWeather(obj);
        }

        @Override
        public MapElement getDocumentation() {
            MapElement element = super.getDocumentation();
            element.addElement(new TextElement("weather", "").setDescription("Which type of Weather should be checkt for (rain/thunder/snowing)"));
            element.addElement(new BooleanElement("required", true, "If the Weather should be present or not"));
            element.addElement(new BooleanElement("directly", false, "If the Block should be directly in the Rain"));
            element.setDescription("Allows to check for the Weather and if the Block is directly effected by it");
            return element;
        }

        @Override
        public void addExample(JsonObject obj) {
            obj.addProperty("weather", "snowing");
            obj.addProperty("required", Boolean.valueOf(true));
            obj.addProperty("directly", Boolean.valueOf(true));
        }
    }
}

