/*
 * Decompiled with CFR 0.152.
 */
package scavenge.world.blockConditions;

import com.google.gson.JsonObject;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import scavenge.api.autodoc.BooleanElement;
import scavenge.api.autodoc.ChoiceElement;
import scavenge.api.autodoc.IntElement;
import scavenge.api.autodoc.MapElement;
import scavenge.api.block.IResourceCondition;
import scavenge.api.block.IResourceFactory;
import scavenge.api.block.IResourceProperty;
import scavenge.api.block.impl.BaseResourceFactory;
import scavenge.api.block.impl.BaseResourceProperty;
import scavenge.api.math.IMathOperation;
import scavenge.api.utils.JsonUtil;
import scavenge.core.math.operation.EqualsNotOperation;
import scavenge.core.math.operation.EqualsOperation;

public class PropHasMeta
extends BaseResourceProperty
implements IResourceCondition {
    IMathOperation operation;

    public PropHasMeta(JsonObject obj) {
        super(obj, "has_meta");
        if (obj.has("operations")) {
            this.operation = JsonUtil.getMathOperation("operations", obj);
            this.setJEIInfo(JsonUtil.getOrDefault(obj, "jeiDesc", ""));
        } else {
            int value = obj.get("meta").getAsInt();
            if (JsonUtil.getOrDefault(obj, "required", true)) {
                this.operation = new EqualsOperation(value);
                this.setJEIInfo("Block Meta has to be " + value);
            } else {
                this.operation = new EqualsNotOperation(value);
                this.setJEIInfo("Block Meta has not to be " + value);
            }
        }
    }

    @Override
    public boolean canInteract(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean leftClick, EnumFacing side, String resourceID, boolean client) {
        return this.operation.matches(state.func_177230_c().func_176201_c(state));
    }

    public static class HasMetaFactory
    extends BaseResourceFactory {
        public HasMetaFactory() {
            super("has_meta", IResourceFactory.PropertyType.Condition);
        }

        @Override
        public IResourceProperty createObject(JsonObject obj) {
            return new PropHasMeta(obj);
        }

        @Override
        public void addExample(JsonObject obj) {
            obj.addProperty("required", Boolean.valueOf(true));
            obj.addProperty("meta", (Number)4);
        }

        @Override
        public MapElement getDocumentation() {
            MapElement element = super.getDocumentation();
            element.setDescription("Allows to check for if the Block has a Certain Metadata");
            ChoiceElement choice = new ChoiceElement("", 2);
            choice.addElement(0, new BooleanElement("required", true, "If the Metadata is required or not"));
            choice.addElement(0, new IntElement("meta", 0).setDescription("Which metadata should be required or not"));
            this.addDefaultOperationText(choice, 1);
            element.addElement(choice);
            return element;
        }
    }
}

