/*
 * Decompiled with CFR 0.152.
 */
package scavenge.world.blockConditions;

import com.google.gson.JsonObject;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import scavenge.api.autodoc.BooleanElement;
import scavenge.api.autodoc.ChoiceElement;
import scavenge.api.autodoc.IntElement;
import scavenge.api.autodoc.MapElement;
import scavenge.api.autodoc.TextElement;
import scavenge.api.block.IResourceCondition;
import scavenge.api.block.IResourceFactory;
import scavenge.api.block.IResourceProperty;
import scavenge.api.block.impl.BaseResourceFactory;
import scavenge.api.block.impl.BaseResourceProperty;
import scavenge.api.math.IMathOperation;
import scavenge.api.utils.CompatState;
import scavenge.api.utils.JsonUtil;
import scavenge.core.math.operation.BiggerOperation;
import scavenge.core.math.operation.EqualsOperation;

public class PropEntityInRange
extends BaseResourceProperty
implements IResourceCondition {
    Class<? extends Entity> entity;
    int radius;
    IMathOperation math;

    public PropEntityInRange(JsonObject obj) {
        super(obj, "require_entity");
        this.entity = EntityList.getClass((ResourceLocation)new ResourceLocation(obj.get("name").getAsString()));
        if (this.entity == null) {
            throw new RuntimeException("EntityName [" + obj.get("name").getAsString() + "] is not registered!");
        }
        this.radius = JsonUtil.getOrDefault(obj, "radius", 5);
        if (obj.has("operations")) {
            this.math = JsonUtil.getMathOperation("operations", obj);
            this.setJEIInfo(JsonUtil.getOrDefault(obj, "jeiDesc", ""));
        } else if (JsonUtil.getOrDefault(obj, "required", true)) {
            this.math = new BiggerOperation(0L);
            this.setJEIInfo("Requires [" + obj.get("name").getAsString() + "] within " + this.radius + " Blocks");
        } else {
            this.math = new EqualsOperation(0L);
            this.setJEIInfo("[" + obj.get("name").getAsString() + "] is not allowed within " + this.radius + " Blocks");
        }
    }

    @Override
    public boolean canInteract(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean leftClick, EnumFacing side, String resourceID, boolean client) {
        return this.math.matches(world.func_72872_a(this.entity, new AxisAlignedBB(pos).func_72321_a((double)this.radius, (double)this.radius, (double)this.radius)).size());
    }

    public static class EntityInRangeFactory
    extends BaseResourceFactory {
        public EntityInRangeFactory() {
            super("require_entity", IResourceFactory.PropertyType.Condition);
            this.setCompatState(CompatState.PARTCOMPATIBLE);
        }

        @Override
        public IResourceProperty createObject(JsonObject obj) {
            return new PropEntityInRange(obj);
        }

        @Override
        public MapElement getDocumentation() {
            MapElement map = super.getDocumentation();
            map.addElement(new TextElement("name", "").setDescription("Which type of Entities should be checkt for"));
            map.addElement(new IntElement("radius", 5, "How far the Check Range should be"));
            ChoiceElement choice = new ChoiceElement("", 2);
            choice.addElement(0, new BooleanElement("required", true, "If the Entity should be present or not"));
            this.addDefaultOperationText(choice, 1);
            map.addElement(choice);
            map.setDescription("Allows to check for Entities to be in range of the position");
            return map;
        }

        @Override
        public void addExample(JsonObject obj) {
            obj.addProperty("name", "PrimedTnt");
            obj.addProperty("radius", (Number)25);
            obj.addProperty("required", Boolean.valueOf(true));
        }
    }
}

