/*
 * Decompiled with CFR 0.152.
 */
package scavenge.world.blockConditions;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import scavenge.api.autodoc.BooleanElement;
import scavenge.api.autodoc.IntElement;
import scavenge.api.autodoc.MapElement;
import scavenge.api.autodoc.OptionalArrayElement;
import scavenge.api.block.IResourceCondition;
import scavenge.api.block.IResourceFactory;
import scavenge.api.block.IResourceProperty;
import scavenge.api.block.impl.BaseResourceFactory;
import scavenge.api.block.impl.BaseResourceProperty;
import scavenge.api.utils.CompatState;
import scavenge.api.utils.JsonUtil;

public class PropDim
extends BaseResourceProperty
implements IResourceCondition {
    Map<Integer, Boolean> map = new HashMap<Integer, Boolean>();
    boolean defaultValue;

    public PropDim(JsonObject obj) {
        super(obj, "require_dimension");
        this.addSelfIncompat();
        this.defaultValue = JsonUtil.getOrDefault(obj, "default", false);
        JsonUtil.convertToObject(obj.get("dimensions"), new Consumer<JsonObject>(){

            @Override
            public void accept(JsonObject t) {
                PropDim.this.map.put(t.get("dim").getAsInt(), t.get("required").getAsBoolean());
            }
        });
    }

    @Override
    public boolean canCombine(IResourceProperty property) {
        return !(property instanceof PropDim);
    }

    @Override
    public void addJEIData(IResourceProperty.IJEIBlockHandler collector) {
        HashSet<Integer> req = new HashSet<Integer>();
        HashSet<Integer> not = new HashSet<Integer>();
        for (Map.Entry<Integer, Boolean> entry : this.map.entrySet()) {
            if (entry.getValue().booleanValue()) {
                req.add(entry.getKey());
                continue;
            }
            not.add(entry.getKey());
        }
        StringBuilder builder = new StringBuilder();
        if (req.size() > 0 && not.isEmpty()) {
            builder.append("Block has to be in either dimension " + req);
        } else if (not.size() > 0 && req.isEmpty()) {
            builder.append("Block is not allowed to be in either dimension " + not);
        } else {
            builder.append("Block is allowed in these dimensions " + req + " and not in dimensions " + not);
        }
    }

    @Override
    public boolean canInteract(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean leftClick, EnumFacing side, String resourceID, boolean client) {
        return this.map.getOrDefault(world.field_73011_w.getDimension(), this.defaultValue);
    }

    public static class DimFactory
    extends BaseResourceFactory {
        public DimFactory() {
            super("require_dimension", IResourceFactory.PropertyType.Condition);
            this.setCompatState(CompatState.INCOMPATIBLE);
        }

        @Override
        public IResourceProperty createObject(JsonObject obj) {
            return new PropDim(obj);
        }

        @Override
        public MapElement getDocumentation() {
            MapElement sub = new MapElement("");
            sub.addElement(new IntElement("dim", 0).setDescription("The Dimension should be required or excluded"));
            sub.addElement(new BooleanElement("required", false).setDescription("If the dimension is required or exluded"));
            MapElement map = super.getDocumentation();
            map.addElement(new OptionalArrayElement("dimension", sub).setDescription("The dimensions that should be included or exluded"));
            map.addElement(new BooleanElement("default", false, "What should be returned if the Dimension isn't found"));
            map.setDescription("Allows to control in which dimensions the block should be in and in which not");
            return map;
        }

        @Override
        public void addExample(JsonObject obj) {
            JsonArray array = new JsonArray();
            obj.add("dimensions", (JsonElement)array);
            JsonObject first = new JsonObject();
            array.add((JsonElement)first);
            first.addProperty("dim", (Number)-1);
            first.addProperty("required", Boolean.valueOf(true));
        }
    }
}

