/*
 * Decompiled with CFR 0.152.
 */
package scavenge.world.blockConditions;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.EnumSet;
import java.util.function.Consumer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import scavenge.api.autodoc.ArrayElement;
import scavenge.api.autodoc.BooleanElement;
import scavenge.api.autodoc.IntElement;
import scavenge.api.autodoc.MapElement;
import scavenge.api.autodoc.TextElement;
import scavenge.api.block.IResourceCondition;
import scavenge.api.block.IResourceFactory;
import scavenge.api.block.IResourceProperty;
import scavenge.api.block.impl.BaseResourceFactory;
import scavenge.api.block.impl.BaseResourceProperty;
import scavenge.api.utils.BlockEntry;
import scavenge.api.utils.CompatState;
import scavenge.api.utils.JsonUtil;

public class PropBlockAround
extends BaseResourceProperty
implements IResourceCondition {
    boolean required;
    boolean and;
    BlockEntry entry;
    EnumSet<EnumFacing> sides = EnumSet.noneOf(EnumFacing.class);

    public PropBlockAround(JsonObject obj) {
        super(obj, "require_block");
        String s;
        this.entry = JsonUtil.createCompareBlockEntry(obj);
        if (this.entry == null) {
            throw new RuntimeException("Entry: [" + obj.get("name") + "] has no Block!");
        }
        this.required = JsonUtil.getOrDefault(obj, "require", true);
        this.and = JsonUtil.getOrDefault(obj, "and", true);
        JsonUtil.convertToPrimitive(obj.get("sides"), new Consumer<JsonPrimitive>(){

            @Override
            public void accept(JsonPrimitive t) {
                EnumFacing side = EnumFacing.func_176739_a((String)t.getAsString());
                if (side != null) {
                    PropBlockAround.this.sides.add(side);
                }
            }
        });
        String string = s = this.and ? "every" : "any";
        if (this.required) {
            this.setJEIInfo("Block [" + this.entry.getName() + "] is required on " + s + " side(s) " + this.sides.toString());
        } else {
            this.setJEIInfo("Block [" + this.entry.getName() + "] is not allowed on " + s + " side(s) " + this.sides.toString());
        }
    }

    @Override
    public boolean canInteract(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean leftClick, EnumFacing clickSide, String resourceID, boolean client) {
        if (this.and) {
            if (this.required) {
                for (EnumFacing side : this.sides) {
                    if (this.entry.matches(world.func_180495_p(pos.func_177972_a(side)))) continue;
                    return false;
                }
                return true;
            }
            for (EnumFacing side : this.sides) {
                if (!this.entry.matches(world.func_180495_p(pos.func_177972_a(side)))) continue;
                return false;
            }
            return true;
        }
        if (this.required) {
            for (EnumFacing side : this.sides) {
                if (!this.entry.matches(world.func_180495_p(pos.func_177972_a(side)))) continue;
                return true;
            }
            return false;
        }
        for (EnumFacing side : this.sides) {
            if (this.entry.matches(world.func_180495_p(pos.func_177972_a(side)))) continue;
            return true;
        }
        return false;
    }

    public static class RequireBlockFactory
    extends BaseResourceFactory {
        public RequireBlockFactory() {
            super("require_block", IResourceFactory.PropertyType.Condition);
            this.setCompatState(CompatState.PARTCOMPATIBLE);
        }

        @Override
        public IResourceProperty createObject(JsonObject obj) {
            return new PropBlockAround(obj);
        }

        @Override
        public MapElement getDocumentation() {
            MapElement map = super.getDocumentation();
            map.addElement(new TextElement("name", "").setDescription("Which Block should be checked for"));
            map.addElement(new IntElement("meta", Short.MAX_VALUE, "Which metadata should be used to check with"));
            map.addElement(new BooleanElement("require", true, "if the Block is required or should not be present"));
            map.addElement(new BooleanElement("and", true, "if All blocks should be that or any amount should be it"));
            map.addElement(new ArrayElement("sides", new TextElement("", "")).setDescription("which sides should be checked for"));
            map.setDescription("Allows to check for Blocks around the Clicked Block");
            return map;
        }

        @Override
        public void addExample(JsonObject obj) {
            obj.addProperty("name", "minecraft:dirt");
            obj.addProperty("meta", (Number)Short.MAX_VALUE);
            obj.addProperty("require", Boolean.valueOf(true));
            obj.addProperty("and", Boolean.valueOf(true));
            JsonArray array = new JsonArray();
            obj.add("sides", (JsonElement)array);
            array.add((JsonElement)new JsonPrimitive("north"));
            array.add((JsonElement)new JsonPrimitive("south"));
        }
    }
}

