/*
 * Decompiled with CFR 0.152.
 */
package scavenge.world.blockConditions;

import com.google.gson.JsonObject;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import scavenge.api.autodoc.BooleanElement;
import scavenge.api.autodoc.ChoiceElement;
import scavenge.api.autodoc.IntElement;
import scavenge.api.autodoc.MapElement;
import scavenge.api.block.IResourceCondition;
import scavenge.api.block.IResourceFactory;
import scavenge.api.block.IResourceProperty;
import scavenge.api.block.impl.BaseResourceFactory;
import scavenge.api.block.impl.BaseResourceProperty;
import scavenge.api.math.IMathOperation;
import scavenge.api.utils.CompatState;
import scavenge.api.utils.JsonUtil;
import scavenge.api.utils.MathUtils;
import scavenge.core.math.operation.BiggerEqualsOperation;
import scavenge.core.math.operation.SmallerEqualsOperation;

public class PropAtSpawn
extends BaseResourceProperty
implements IResourceCondition {
    IMathOperation operation;

    public PropAtSpawn(JsonObject obj) {
        super(obj, "require_Spawn");
        if (obj.has("operations")) {
            this.operation = JsonUtil.getMathOperation("operations", obj);
            this.setJEIInfo(JsonUtil.getOrDefault(obj, "jeiDesc", ""));
        } else {
            int range = JsonUtil.getOrDefault(obj, "radius", 128);
            if (JsonUtil.getOrDefault(obj, "inside", true)) {
                this.operation = new SmallerEqualsOperation(range);
                this.setJEIInfo("Player needs to be in range of the Spawn (" + range + " Block Radius)");
            } else {
                this.operation = new BiggerEqualsOperation(range);
                this.setJEIInfo("Player needs to be outside of the Spawn (" + range + " Block Radius)");
            }
        }
    }

    @Override
    public boolean canInteract(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean leftClick, EnumFacing side, String resourceID, boolean client) {
        return this.operation.matches(MathUtils.getXZDistance(pos, world.func_175694_M()));
    }

    public static class WorldSpawnFactory
    extends BaseResourceFactory {
        public WorldSpawnFactory() {
            super("require_Spawn", IResourceFactory.PropertyType.Condition);
            this.setCompatState(CompatState.PARTCOMPATIBLE);
        }

        @Override
        public IResourceProperty createObject(JsonObject obj) {
            return new PropAtSpawn(obj);
        }

        @Override
        public MapElement getDocumentation() {
            MapElement element = super.getDocumentation();
            element.setDescription("Allows to control if the Block should be inside or outside of the spawn Range");
            ChoiceElement choice = new ChoiceElement("", 2);
            choice.addElement(0, new BooleanElement("inside", true, "If the Block needs to be inside or outside of the Spawn"));
            choice.addElement(0, new IntElement("radius", 128, "The Distance in Blocks how close or far away the Player should be from the Spawn"));
            this.addDefaultOperationText(choice, 1);
            element.addElement(choice);
            return element;
        }

        @Override
        public void addExample(JsonObject obj) {
            obj.addProperty("inside", Boolean.valueOf(true));
            obj.addProperty("radius", (Number)128);
        }
    }
}

