/*
 * Decompiled with CFR 0.152.
 */
package scavenge.utils.blockEffects;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import scavenge.api.autodoc.ArrayElement;
import scavenge.api.autodoc.ChoiceElement;
import scavenge.api.autodoc.IntElement;
import scavenge.api.autodoc.MapElement;
import scavenge.api.block.EffectContainer;
import scavenge.api.block.IResourceEffect;
import scavenge.api.block.IResourceFactory;
import scavenge.api.block.IResourceProperty;
import scavenge.api.block.impl.BaseResourceFactory;
import scavenge.api.block.impl.BaseResourceProperty;
import scavenge.api.utils.JsonUtil;

public class PropSetRools
extends BaseResourceProperty
implements IResourceEffect {
    List<Integer> rools = new ArrayList<Integer>();

    public PropSetRools(JsonObject obj) {
        super(obj, "set_rools");
        this.setJEIInfo("Changes the Loot Drops");
        if (obj.has("pool")) {
            JsonUtil.convertToPrimitive((JsonElement)obj, new Consumer<JsonPrimitive>(){

                @Override
                public void accept(JsonPrimitive t) {
                    PropSetRools.this.rools.add(t.getAsInt());
                }
            });
        } else {
            this.rools.add(obj.get("amount").getAsInt());
        }
    }

    @Override
    public boolean applyEffects(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean left, EnumFacing side, String resourceID, EffectContainer container) {
        container.addDropRolls(this.rools.get(world.field_73012_v.nextInt(this.rools.size())));
        return true;
    }

    public static class SetRoolsFactory
    extends BaseResourceFactory {
        public SetRoolsFactory() {
            super("set_rools", IResourceFactory.PropertyType.Effect);
        }

        @Override
        public IResourceProperty createObject(JsonObject obj) {
            return new PropSetRools(obj);
        }

        @Override
        public void addExample(JsonObject obj) {
            obj.addProperty("amount", (Number)0);
        }

        @Override
        public MapElement getDocumentation() {
            MapElement map = super.getDocumentation();
            ChoiceElement choice = new ChoiceElement("", 2);
            choice.addElement(0, new IntElement("amount", 0).setDescription("The Amount of Rools that the loot pools should get"));
            choice.addElement(1, new ArrayElement("pool", new IntElement("", 0)).setDescription("Pool of Numbers which 1 gets pickt randomly from"));
            map.addElement(choice);
            map.setDescription("Allows to set a Fixed or Random Loot Rools");
            return map;
        }
    }
}

