/*
 * Decompiled with CFR 0.152.
 */
package scavenge.utils.blockEffects;

import com.google.gson.JsonObject;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import scavenge.api.autodoc.DoubleElement;
import scavenge.api.autodoc.IntElement;
import scavenge.api.autodoc.MapElement;
import scavenge.api.block.EffectContainer;
import scavenge.api.block.IResourceEffect;
import scavenge.api.block.IResourceFactory;
import scavenge.api.block.IResourceProperty;
import scavenge.api.block.impl.BaseResourceFactory;
import scavenge.api.block.impl.BaseResourceProperty;
import scavenge.api.utils.JsonUtil;

public class PropSetLuck
extends BaseResourceProperty
implements IResourceEffect {
    float multiplier;
    int points;

    public PropSetLuck(JsonObject obj) {
        super(obj, "modify_luck");
        this.multiplier = JsonUtil.getOrDefault(obj, "multiplier", 0.0f);
        this.points = JsonUtil.getOrDefault(obj, "points", 0);
        this.setJEIInfo("Modifies Loot Drop Luck!");
    }

    @Override
    public boolean applyEffects(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean left, EnumFacing side, String resourceID, EffectContainer container) {
        container.addLuckModifier(this.multiplier);
        container.addLuckPoints(this.points);
        return true;
    }

    public static class SetLuckFactory
    extends BaseResourceFactory {
        public SetLuckFactory() {
            super("modify_luck", IResourceFactory.PropertyType.Effect);
        }

        @Override
        public IResourceProperty createObject(JsonObject obj) {
            return new PropSetLuck(obj);
        }

        @Override
        public void addExample(JsonObject obj) {
            obj.addProperty("multiplier", (Number)0.1);
            obj.addProperty("points", (Number)2);
        }

        @Override
        public MapElement getDocumentation() {
            MapElement map = super.getDocumentation();
            map.setDescription("Allows to modify chance of Loot Drop, for reducing negative numbers are used since its added on top of base chance");
            map.addElement(new DoubleElement("multiplier", 0.0, "the Multiplier thats being added on top of the base chance"));
            map.addElement(new IntElement("points", 0, "Adds Exact % on top of base chance"));
            return map;
        }
    }
}

