/*
 * Decompiled with CFR 0.152.
 */
package scavenge.utils.blockEffects;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import scavenge.api.autodoc.ArrayElement;
import scavenge.api.autodoc.MapElement;
import scavenge.api.block.EffectContainer;
import scavenge.api.block.IResourceCondition;
import scavenge.api.block.IResourceEffect;
import scavenge.api.block.IResourceFactory;
import scavenge.api.block.IResourceProperty;
import scavenge.api.block.impl.BaseResourceFactory;
import scavenge.api.block.impl.BaseResourceProperty;
import scavenge.api.utils.JsonUtil;

public class PropConditionalEffect
extends BaseResourceProperty
implements IResourceEffect {
    List<IResourceEffect> effects = new ArrayList<IResourceEffect>();
    IResourceCondition condition;

    public PropConditionalEffect(JsonObject obj) {
        super(obj, "conditional_Effect");
        this.condition = this.createCondition(obj.getAsJsonObject("condition"));
        JsonUtil.convertToObject(obj.get("effects"), new Consumer<JsonObject>(){

            @Override
            public void accept(JsonObject t) {
                PropConditionalEffect.this.effects.add(PropConditionalEffect.this.createEffect(t));
            }
        });
    }

    @Override
    public void addJEIData(IResourceProperty.IJEIBlockHandler collector) {
        collector.addExtraLayer("Optional Effects");
        collector.addInfo("If this condition is met:");
        this.condition.addJEIData(collector);
        collector.addInfo("");
        collector.addInfo("Then these effects will be applied: ");
        for (IResourceEffect effect : this.effects) {
            effect.addJEIData(collector);
        }
        collector.finishLayer();
    }

    @Override
    public boolean applyEffects(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean left, EnumFacing side, String resourceID, EffectContainer container) {
        if (this.condition.canInteract(state, world, pos, player, left, side, resourceID, false)) {
            for (IResourceEffect effect : this.effects) {
                effect.applyEffects(state, world, pos, player, left, side, resourceID, container);
            }
            return true;
        }
        return false;
    }

    public static class ConditionalEffectFactory
    extends BaseResourceFactory {
        public ConditionalEffectFactory() {
            super("conditional_Effect", IResourceFactory.PropertyType.Effect);
        }

        @Override
        public IResourceProperty createObject(JsonObject obj) {
            return new PropConditionalEffect(obj);
        }

        @Override
        public void addExample(JsonObject obj) {
            JsonObject condition = new JsonObject();
            condition.addProperty("type", "exampleCondition");
            obj.add("condition", (JsonElement)condition);
            JsonObject effect = new JsonObject();
            effect.addProperty("type", "ExampleEffect");
            JsonArray array = new JsonArray();
            array.add((JsonElement)effect);
            obj.add("effects", (JsonElement)array);
        }

        @Override
        public MapElement getDocumentation() {
            MapElement map = super.getDocumentation();
            map.setDescription("Allows to make optional Effect based on 1 condition");
            map.addElement(new MapElement("condition").setDescription("The Condition object thats being checkt for"));
            map.addElement(new ArrayElement("effects", map).setDescription("The Effects that should be applied"));
            return map;
        }
    }
}

