/*
 * Decompiled with CFR 0.152.
 */
package scavenge.utils.blockConditions;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import scavenge.api.autodoc.MapElement;
import scavenge.api.block.IResourceCondition;
import scavenge.api.block.IResourceFactory;
import scavenge.api.block.IResourceProperty;
import scavenge.api.block.impl.BaseResourceFactory;
import scavenge.api.block.impl.BaseResourceProperty;

public class PropInvertCondition
extends BaseResourceProperty
implements IResourceCondition {
    IResourceCondition condition;

    public PropInvertCondition(JsonObject obj) {
        super(obj, "invert_Condition");
        this.condition = this.createCondition(obj.getAsJsonObject("value"));
    }

    @Override
    public void addJEIData(IResourceProperty.IJEIBlockHandler collector) {
        collector.addExtraLayer("Inverts Condition");
        this.condition.addJEIData(collector);
        collector.finishLayer();
    }

    @Override
    public boolean canInteract(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean leftClick, EnumFacing side, String resourceID, boolean client) {
        return !this.condition.canInteract(state, world, pos, player, leftClick, side, resourceID, client);
    }

    public static class InvertConditionFactory
    extends BaseResourceFactory {
        public InvertConditionFactory() {
            super("invert_Condition", IResourceFactory.PropertyType.Condition);
        }

        @Override
        public IResourceProperty createObject(JsonObject obj) {
            return new PropInvertCondition(obj);
        }

        @Override
        public void addExample(JsonObject obj) {
            JsonObject data = new JsonObject();
            data.addProperty("type", "exampleCondition");
            obj.add("value", (JsonElement)data);
        }

        @Override
        public MapElement getDocumentation() {
            MapElement map = super.getDocumentation();
            map.setDescription("Allows to invert any other condition");
            map.addElement(new MapElement("value").setDescription("The Container where the condition is stored in that needs to be inverted"));
            return map;
        }
    }
}

