/*
 * Decompiled with CFR 0.152.
 */
package scavenge.tileentity.blockConditions;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import scavenge.api.autodoc.IntElement;
import scavenge.api.autodoc.MapElement;
import scavenge.api.autodoc.OptionalArrayElement;
import scavenge.api.autodoc.TextElement;
import scavenge.api.block.IResourceCondition;
import scavenge.api.block.IResourceFactory;
import scavenge.api.block.IResourceProperty;
import scavenge.api.block.impl.BaseResourceFactory;
import scavenge.api.block.impl.BaseResourceProperty;
import scavenge.api.utils.CompatState;
import scavenge.api.utils.JsonUtil;
import scavenge.api.utils.LootUtil;
import scavenge.api.utils.StackObject;

public class PropTileEntityHasItems
extends BaseResourceProperty
implements IResourceCondition {
    List<StackObject> list = new ArrayList<StackObject>();

    public PropTileEntityHasItems(JsonObject obj) {
        super(obj, "require_tile_items");
        JsonUtil.convertToObject(obj.get("items"), new Consumer<JsonObject>(){

            @Override
            public void accept(JsonObject t) {
                StackObject stack = JsonUtil.createStackObject(t);
                if (stack == null) {
                    throw new RuntimeException("Compare Stack for data [" + t + "] is Null");
                }
                PropTileEntityHasItems.this.list.add(stack);
            }
        });
    }

    @Override
    public void addJEIData(IResourceProperty.IJEIBlockHandler collector) {
        collector.addExtraLayer("Block TileEntity has to have Items");
        for (StackObject obj : this.list) {
            collector.addInfo(obj.getStackize() + "x " + obj.getName());
        }
        collector.finishLayer();
    }

    @Override
    public boolean canInteract(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean leftClick, EnumFacing side, String resourceID, boolean client) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile == null || !tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
            return false;
        }
        IItemHandler handler = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        ArrayList<StackObject> toCheck = new ArrayList<StackObject>(this.list.size());
        for (StackObject obj : this.list) {
            toCheck.add(obj);
        }
        int count = handler.getSlots();
        for (int i = 0; i < count; ++i) {
            ItemStack stack = handler.getStackInSlot(i);
            if (LootUtil.isStackEmpty(stack)) continue;
            int stackSize = LootUtil.getStackSize(stack);
            Iterator iter = toCheck.iterator();
            while (iter.hasNext()) {
                StackObject obj = (StackObject)iter.next();
                if (!obj.matches(stack)) continue;
                if (obj.getStackize() <= stackSize) {
                    stackSize -= obj.getStackize();
                    iter.remove();
                } else {
                    obj.decreaseStackSize(stackSize);
                    stackSize = 0;
                }
                if (stackSize > 0) continue;
                break;
            }
            if (toCheck.isEmpty()) break;
        }
        return toCheck.isEmpty();
    }

    public static class TileEntityHasItemsFactory
    extends BaseResourceFactory {
        public TileEntityHasItemsFactory() {
            super("require_tile_items", IResourceFactory.PropertyType.Condition);
            this.setCompatState(CompatState.PARTCOMPATIBLE);
        }

        @Override
        public IResourceProperty createObject(JsonObject obj) {
            return new PropTileEntityHasItems(obj);
        }

        @Override
        public void addExample(JsonObject obj) {
            JsonObject object = new JsonObject();
            object.addProperty("name", "minecraft:stick");
            object.addProperty("amount", (Number)32);
            JsonArray array = new JsonArray();
            array.add((JsonElement)object);
            obj.add("items", (JsonElement)array);
        }

        @Override
        public MapElement getDocumentation() {
            MapElement base = new MapElement("");
            base.addElement(new TextElement("name", "").setDescription("The Item that should be searched for"));
            base.addElement(new IntElement("meta", Short.MAX_VALUE, "The Metadata that should be searched for"));
            base.addElement(new IntElement("amount", 1, "The Stacksize that should be searched for"));
            base.addElement(new TextElement("nbt", "null", "The NBTData that should be checkt for. Defaults to ignore"));
            MapElement map = super.getDocumentation();
            map.addElement(new OptionalArrayElement("items", base));
            map.setDescription("Allows to check if the Block TileEntity has a set of items present");
            return map;
        }
    }
}

