/*
 * Decompiled with CFR 0.152.
 */
package scavenge.tileentity.blockConditions;

import com.google.gson.JsonObject;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import scavenge.api.autodoc.BooleanElement;
import scavenge.api.autodoc.IntElement;
import scavenge.api.autodoc.MapElement;
import scavenge.api.autodoc.TextElement;
import scavenge.api.block.IResourceCondition;
import scavenge.api.block.IResourceFactory;
import scavenge.api.block.IResourceProperty;
import scavenge.api.block.impl.BaseResourceFactory;
import scavenge.api.block.impl.BaseResourceProperty;
import scavenge.api.utils.CompatState;
import scavenge.api.utils.JsonUtil;

public class PropTankHasFluid
extends BaseResourceProperty
implements IResourceCondition {
    FluidStack fluid;
    boolean exactAmount;

    public PropTankHasFluid(JsonObject obj) {
        super(obj, "tile_has_fluid");
        this.fluid = JsonUtil.createFluidStack(obj);
        this.exactAmount = JsonUtil.getOrDefault(obj, "exact", true);
        if (this.fluid == null) {
            throw new RuntimeException("Object [" + obj + "] is causing a Null Fluid thats not allowed");
        }
        this.setJEIInfo("Block TileEntity has to have " + this.fluid.amount + "mB Fluid [" + this.fluid.getLocalizedName() + "]");
    }

    @Override
    public boolean canInteract(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean leftClick, EnumFacing side, String resourceID, boolean client) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile == null || !tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)) {
            return false;
        }
        IFluidHandler handler = (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
        return this.exactAmount ? this.fluid.containsFluid(handler.drain(this.fluid, false)) : this.fluid.isFluidEqual(handler.drain(this.fluid, false));
    }

    public static class TileHasFluidFactory
    extends BaseResourceFactory {
        public TileHasFluidFactory() {
            super("tile_has_fluid", IResourceFactory.PropertyType.Condition);
            this.setCompatState(CompatState.PARTCOMPATIBLE);
        }

        @Override
        public IResourceProperty createObject(JsonObject obj) {
            return new PropTankHasFluid(obj);
        }

        @Override
        public void addExample(JsonObject obj) {
            obj.addProperty("name", "minecraft:water");
            obj.addProperty("amount", (Number)1000);
        }

        @Override
        public MapElement getDocumentation() {
            MapElement map = super.getDocumentation();
            map.setDescription("Allows to check if the TileEntity has a Fluid stored");
            map.addElement(new TextElement("name", "").setDescription("The Fluid Registry name of the Fluid that should be checkt for"));
            map.addElement(new IntElement("amount", 1000, "How much the liquid should be checkt for"));
            map.addElement(new BooleanElement("exact", true, "If the Exact amount should be present or any Amount"));
            return map;
        }
    }
}

