/*
 * Decompiled with CFR 0.152.
 */
package scavenge.score.blockEffects;

import com.google.gson.JsonObject;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.stats.StatBase;
import net.minecraft.stats.StatList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import scavenge.api.autodoc.BooleanElement;
import scavenge.api.autodoc.IntElement;
import scavenge.api.autodoc.MapElement;
import scavenge.api.autodoc.TextElement;
import scavenge.api.block.EffectContainer;
import scavenge.api.block.IResourceEffect;
import scavenge.api.block.IResourceFactory;
import scavenge.api.block.IResourceProperty;
import scavenge.api.block.impl.BaseResourceFactory;
import scavenge.api.block.impl.BaseResourceProperty;
import scavenge.api.utils.JsonUtil;

public class PropAddStat
extends BaseResourceProperty
implements IResourceEffect {
    StatBase base;
    boolean increase;
    int value;

    public PropAddStat(JsonObject obj) {
        super(obj, "add_stat");
        this.base = StatList.func_151177_a((String)obj.get("name").getAsString());
        if (this.base == null) {
            throw new RuntimeException("Stat [" + obj.get("name").getAsString() + "] is null that is not allowed");
        }
        this.increase = JsonUtil.getOrDefault(obj, "increase", true);
        this.value = JsonUtil.getOrDefault(obj, "amount", 1);
        if (this.increase) {
            this.setJEIInfo("Increases the stat [" + this.base.func_150951_e().func_150254_d() + "] by " + this.value);
        } else {
            this.setJEIInfo("Decreases the stat [" + this.base.func_150951_e().func_150254_d() + "] by " + this.value);
        }
    }

    @Override
    public boolean applyEffects(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean left, EnumFacing side, String resourceID, EffectContainer container) {
        player.func_71064_a(this.base, this.increase ? this.value : -this.value);
        return true;
    }

    public static class AddStatFactory
    extends BaseResourceFactory {
        public AddStatFactory() {
            super("add_stat", IResourceFactory.PropertyType.Effect);
        }

        @Override
        public IResourceProperty createObject(JsonObject obj) {
            return new PropAddStat(obj);
        }

        @Override
        public void addExample(JsonObject obj) {
            obj.addProperty("name", "stat.animalsBred");
            obj.addProperty("increase", Boolean.valueOf(true));
            obj.addProperty("amount", (Number)10);
        }

        @Override
        public MapElement getDocumentation() {
            MapElement map = super.getDocumentation();
            map.addElement(new TextElement("name", "").setDescription("The StatRegistry name that should be changed"));
            map.addElement(new BooleanElement("increase", true, "If the Stat should be increased or decreased"));
            map.addElement(new IntElement("amount", 1, "How much the stat should be modified"));
            map.setDescription("Allows to Modify Stat Points");
            return map;
        }
    }
}

