/*
 * Decompiled with CFR 0.152.
 */
package scavenge.score.blockEffects;

import com.google.gson.JsonObject;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.PlayerAdvancements;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import scavenge.api.autodoc.MapElement;
import scavenge.api.autodoc.TextElement;
import scavenge.api.block.EffectContainer;
import scavenge.api.block.IResourceEffect;
import scavenge.api.block.IResourceFactory;
import scavenge.api.block.IResourceProperty;
import scavenge.api.block.impl.BaseResourceFactory;
import scavenge.api.block.impl.BaseResourceProperty;

public class PropAddAchievement
extends BaseResourceProperty
implements IResourceEffect {
    ResourceLocation achievement;

    public PropAddAchievement(JsonObject obj) {
        super(obj, "add_Achievement");
        this.achievement = new ResourceLocation(obj.get("name").getAsString());
        this.setJEIInfo("Adds Achievement [" + this.achievement.toString() + "]");
    }

    @Override
    public boolean applyEffects(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean left, EnumFacing side, String resourceID, EffectContainer container) {
        Advancement adv = this.getAdvancment();
        if (adv == null) {
            return false;
        }
        PlayerAdvancements playerList = this.getPlayerAdvancements(player);
        if (playerList == null) {
            return false;
        }
        for (String s : playerList.func_192747_a(adv).func_192107_d()) {
            playerList.func_192750_a(adv, s);
        }
        return true;
    }

    public PlayerAdvancements getPlayerAdvancements(EntityPlayer player) {
        if (player instanceof EntityPlayerMP) {
            return ((EntityPlayerMP)player).func_192039_O();
        }
        return null;
    }

    public Advancement getAdvancment() {
        return FMLCommonHandler.instance().getMinecraftServerInstance().func_191949_aK().func_192778_a(this.achievement);
    }

    public static class AddAchievementFactory
    extends BaseResourceFactory {
        public AddAchievementFactory() {
            super("add_Achievement", IResourceFactory.PropertyType.Effect);
        }

        @Override
        public IResourceProperty createObject(JsonObject obj) {
            return new PropAddAchievement(obj);
        }

        @Override
        public void addExample(JsonObject obj) {
            obj.addProperty("name", "achievement.openInventory");
        }

        @Override
        public MapElement getDocumentation() {
            MapElement map = super.getDocumentation();
            map.addElement(new TextElement("name", "").setDescription("The Achievement that should be given"));
            map.setDescription("Allows to Add Achievements to a Player");
            return map;
        }
    }
}

