/*
 * Decompiled with CFR 0.152.
 */
package scavenge.score.blockConditions;

import com.google.gson.JsonObject;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import scavenge.api.autodoc.BooleanElement;
import scavenge.api.autodoc.MapElement;
import scavenge.api.autodoc.TextElement;
import scavenge.api.block.IResourceCondition;
import scavenge.api.block.IResourceFactory;
import scavenge.api.block.IResourceProperty;
import scavenge.api.block.impl.BaseResourceFactory;
import scavenge.api.block.impl.BaseResourceProperty;
import scavenge.api.utils.CompatState;
import scavenge.api.utils.JsonUtil;

public class PropHasAchievement
extends BaseResourceProperty
implements IResourceCondition {
    ResourceLocation stat;
    boolean required;

    public PropHasAchievement(JsonObject obj) {
        super(obj, "require_achievement");
        this.stat = new ResourceLocation(obj.get("name").getAsString());
        if (this.stat == null) {
            throw new RuntimeException("Achievement [" + obj.get("name").getAsString() + "] is null that is not allowed");
        }
        this.required = JsonUtil.getOrDefault(obj, "required", true);
        if (this.required) {
            this.setJEIInfo("Player Requires [" + this.stat.toString() + "] Achievement");
        } else {
            this.setJEIInfo("Player should not have the [" + this.stat.toString() + "] Achievement");
        }
    }

    @Override
    public boolean canInteract(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean leftClick, EnumFacing side, String resourceID, boolean client) {
        return this.hasServerAdvancements(player, client) == this.required;
    }

    public boolean hasServerAdvancements(EntityPlayer player, boolean client) {
        if (player instanceof EntityPlayerMP) {
            return ((EntityPlayerMP)player).func_192039_O().func_192747_a(FMLCommonHandler.instance().getMinecraftServerInstance().func_191949_aK().func_192778_a(this.stat)).func_192105_a();
        }
        if (client) {
            return this.required;
        }
        return false;
    }

    public static class HasAchievementFactory
    extends BaseResourceFactory {
        public HasAchievementFactory() {
            super("require_achievement", IResourceFactory.PropertyType.Condition);
            this.setCompatState(CompatState.PARTCOMPATIBLE);
        }

        @Override
        public IResourceProperty createObject(JsonObject obj) {
            return new PropHasAchievement(obj);
        }

        @Override
        public void addExample(JsonObject obj) {
            obj.addProperty("name", "achievement.openInventory");
            obj.addProperty("required", Boolean.valueOf(true));
        }

        @Override
        public MapElement getDocumentation() {
            MapElement map = super.getDocumentation();
            map.setDescription("Allows to check for a Achievement");
            map.addElement(new TextElement("name", "").setDescription("The Achievement Registy name of the Achievment that should be checkt for"));
            map.addElement(new BooleanElement("required", true, "If the achievement should be required or not"));
            return map;
        }
    }
}

