/*
 * Decompiled with CFR 0.152.
 */
package scavenge.player.blockMixed;

import com.google.gson.JsonObject;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketBlockBreakAnim;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import scavenge.api.autodoc.BooleanElement;
import scavenge.api.autodoc.ChoiceElement;
import scavenge.api.autodoc.IntElement;
import scavenge.api.autodoc.MapElement;
import scavenge.api.autodoc.TextElement;
import scavenge.api.block.EffectContainer;
import scavenge.api.block.IResourceCondition;
import scavenge.api.block.IResourceEffect;
import scavenge.api.block.IResourceFactory;
import scavenge.api.block.IResourceProperty;
import scavenge.api.block.impl.BaseResourceFactory;
import scavenge.api.block.impl.BaseResourceProperty;
import scavenge.api.utils.CompatState;
import scavenge.api.utils.JsonUtil;

public class PropPerPlayer
extends BaseResourceProperty
implements IResourceCondition,
IResourceEffect {
    String id;
    int usage;
    int max;
    int min;
    boolean decrease;

    public PropPerPlayer(JsonObject obj) {
        super(obj, "per_player_limit");
        this.addIncompats("per_block_limit", "per_player_limit", "per_chunk_limit");
        this.id = JsonUtil.getOrDefault(obj, "id", null);
        if (JsonUtil.getOrDefault(obj, "increase", true)) {
            this.decrease = false;
            this.min = 0;
            this.max = obj.get("max").getAsInt();
            this.usage = JsonUtil.getOrDefault(obj, "usage", 1);
        } else {
            this.decrease = true;
            this.min = JsonUtil.getOrDefault(obj, "min", 0);
            this.max = obj.get("max").getAsInt();
            this.usage = JsonUtil.getOrDefault(obj, "usage", 1);
        }
    }

    @Override
    public boolean canInteract(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean leftClick, EnumFacing side, String resourceID, boolean client) {
        int value = this.getUsage(player, resourceID);
        if (this.decrease) {
            if (value <= this.min) {
                this.sendPacketToPlayer(player, (Packet)new SPacketBlockBreakAnim(pos.hashCode(), pos, this.getValue(value)));
                return false;
            }
        } else if (value >= this.max) {
            this.sendPacketToPlayer(player, (Packet)new SPacketBlockBreakAnim(pos.hashCode(), pos, 9));
            return false;
        }
        return true;
    }

    @Override
    public boolean applyEffects(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean left, EnumFacing side, String resourceID, EffectContainer container) {
        int value = this.getUsage(player, resourceID) + (this.decrease ? -this.usage : this.usage);
        this.setId(player, resourceID, value);
        this.sendPacketToPlayer(player, (Packet)new SPacketBlockBreakAnim(pos.hashCode(), pos, this.getValue(value)));
        return false;
    }

    public int getUsage(EntityPlayer player, String res) {
        return player.getEntityData().func_74762_e(this.id == null ? res : this.id);
    }

    public void setId(EntityPlayer player, String res, int value) {
        player.getEntityData().func_74768_a(this.id == null ? res : this.id, value);
    }

    public int getValue(int value) {
        float result = (float)value / (float)this.max;
        return (int)(result * 9.0f);
    }

    public static class PerPlayerFactory
    extends BaseResourceFactory {
        public PerPlayerFactory() {
            super("per_player_limit", IResourceFactory.PropertyType.ConditionEffect);
            this.setCompatState(CompatState.INCOMPATIBLE);
            this.addIncompat("per_block_limit", CompatState.INCOMPATIBLE);
            this.addIncompat("per_chunk_limit", CompatState.INCOMPATIBLE);
        }

        @Override
        public IResourceProperty createObject(JsonObject obj) {
            return new PropPerPlayer(obj);
        }

        @Override
        public MapElement getDocumentation() {
            MapElement map = super.getDocumentation();
            map.addElement(new TextElement("id", "ResourceID", "Custom ID for the Counter for the per Player Data"));
            map.addElement(new BooleanElement("increase", true, "If the it should be used up or reduced"));
            ChoiceElement choice = new ChoiceElement("", 2);
            choice.addElement(0, new IntElement("usage", 1, "How much the Value should increase"));
            choice.addElement(0, new IntElement("max", 0).setDescription("How much the limit should be"));
            choice.addElement(1, new IntElement("usage", 1, "How much the Value should decrease"));
            choice.addElement(1, new IntElement("max", 0).setDescription("What the max should be (for the progress-animation)"));
            choice.addElement(1, new IntElement("min", 0, "What the lower value should be."));
            map.addElement(choice);
            map.setDescription("Allows to limit the Usage of a Block per Player");
            return map;
        }

        @Override
        public void addExample(JsonObject obj) {
            obj.addProperty("usage", (Number)1);
            obj.addProperty("max", (Number)20);
        }
    }
}

