/*
 * Decompiled with CFR 0.152.
 */
package scavenge.player.blockEffects;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.Potion;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import scavenge.api.autodoc.ArrayElement;
import scavenge.api.autodoc.DoubleElement;
import scavenge.api.autodoc.MapElement;
import scavenge.api.autodoc.TextElement;
import scavenge.api.block.EffectContainer;
import scavenge.api.block.IResourceEffect;
import scavenge.api.block.IResourceFactory;
import scavenge.api.block.IResourceProperty;
import scavenge.api.block.impl.BaseResourceFactory;
import scavenge.api.block.impl.BaseResourceProperty;
import scavenge.api.utils.JsonUtil;

public class PropRemovePotion
extends BaseResourceProperty
implements IResourceEffect {
    List<Potion> potions = new ArrayList<Potion>();
    double chance;

    public PropRemovePotion(JsonObject obj) {
        super(obj, "remove_potion");
        this.chance = JsonUtil.getOrDefault(obj, "chance", 100.0);
        JsonUtil.convertToPrimitive(obj.get("potions"), new Consumer<JsonPrimitive>(){

            @Override
            public void accept(JsonPrimitive t) {
                Potion potion = (Potion)Potion.field_188414_b.func_82594_a((Object)new ResourceLocation(t.getAsString()));
                if (potion == null) {
                    throw new RuntimeException("Potion [" + t + "] was not found");
                }
                PropRemovePotion.this.potions.add(potion);
            }
        });
    }

    @Override
    public void addJEIData(IResourceProperty.IJEIBlockHandler collector) {
        collector.addExtraLayer("Removes Potion Effects");
        collector.addInfo("Removes these Potion Effects with a [" + this.chance + "%] from the Player");
        for (Potion p : this.potions) {
            collector.addInfo(I18n.func_74838_a((String)p.func_76393_a()));
        }
        collector.finishLayer();
    }

    @Override
    public boolean applyEffects(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean left, EnumFacing side, String resourceID, EffectContainer container) {
        if (this.chance >= world.field_73012_v.nextDouble() * 100.0) {
            for (Potion p : this.potions) {
                player.func_184589_d(p);
            }
            return true;
        }
        return false;
    }

    public static class RemovePotionFactory
    extends BaseResourceFactory {
        public RemovePotionFactory() {
            super("remove_potion", IResourceFactory.PropertyType.Effect);
        }

        @Override
        public IResourceProperty createObject(JsonObject obj) {
            return new PropRemovePotion(obj);
        }

        @Override
        public void addExample(JsonObject obj) {
            JsonArray array = new JsonArray();
            array.add((JsonElement)new JsonPrimitive("minecraft:confusion"));
            array.add((JsonElement)new JsonPrimitive("minecraft:strenght"));
            obj.add("potions", (JsonElement)array);
        }

        @Override
        public MapElement getDocumentation() {
            MapElement map = super.getDocumentation();
            map.addElement(new DoubleElement("chance", 100.0, "The Chance of how likely the Potion Effects will be removed"));
            map.addElement(new ArrayElement("potions", new TextElement("", "")).setDescription("The Potion Registry names of the Potions that should be removed"));
            map.setDescription("Allows to remove Potion Effects from a Player");
            return map;
        }
    }
}

