/*
 * Decompiled with CFR 0.152.
 */
package scavenge.player.blockConditions;

import com.google.gson.JsonObject;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import scavenge.api.autodoc.BooleanElement;
import scavenge.api.autodoc.MapElement;
import scavenge.api.block.IResourceCondition;
import scavenge.api.block.IResourceFactory;
import scavenge.api.block.IResourceProperty;
import scavenge.api.block.impl.BaseResourceFactory;
import scavenge.api.block.impl.BaseResourceProperty;
import scavenge.api.utils.CompatState;
import scavenge.api.utils.JsonUtil;

public class PropPlayerSneak
extends BaseResourceProperty
implements IResourceCondition {
    boolean should;

    public PropPlayerSneak(JsonObject obj) {
        super(obj, "require_sneak");
        this.addSelfIncompat();
        this.should = JsonUtil.getOrDefault(obj, "sneak", true);
        this.setJEIInfo(this.should ? "Player needs to Sneak" : "Player isn't allowed to Sneak");
    }

    @Override
    public boolean canInteract(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean leftClick, EnumFacing side, String resourceID, boolean client) {
        return player.func_70093_af() == this.should;
    }

    public static class PlayerSneakFactory
    extends BaseResourceFactory {
        public PlayerSneakFactory() {
            super("require_sneak", IResourceFactory.PropertyType.Condition);
            this.setCompatState(CompatState.INCOMPATIBLE);
        }

        @Override
        public IResourceProperty createObject(JsonObject obj) {
            return new PropPlayerSneak(obj);
        }

        @Override
        public MapElement getDocumentation() {
            MapElement element = super.getDocumentation();
            element.addElement(new BooleanElement("sneak", true, "If the Player should sneak or not"));
            element.setDescription("Allows to check if a player is sneaking");
            return element;
        }

        @Override
        public void addExample(JsonObject obj) {
            obj.addProperty("sneak", Boolean.valueOf(true));
        }
    }
}

