/*
 * Decompiled with CFR 0.152.
 */
package scavenge.player.blockConditions;

import com.google.gson.JsonObject;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import scavenge.api.autodoc.MapElement;
import scavenge.api.autodoc.TextElement;
import scavenge.api.block.IResourceCondition;
import scavenge.api.block.IResourceFactory;
import scavenge.api.block.IResourceProperty;
import scavenge.api.block.impl.BaseResourceFactory;
import scavenge.api.block.impl.BaseResourceProperty;

public class PropPlayerHasTag
extends BaseResourceProperty
implements IResourceCondition {
    String id;

    public PropPlayerHasTag(JsonObject obj) {
        super(obj, "player_has_tag");
        this.id = obj.get("tagID").getAsString();
        this.setJEIInfo("Player has to have tagID [" + this.id + "]");
    }

    @Override
    public boolean canInteract(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean leftClick, EnumFacing side, String resourceID, boolean client) {
        return client || player.getEntityData().func_74764_b(this.id);
    }

    public static class PlayerHasTagFactory
    extends BaseResourceFactory {
        public PlayerHasTagFactory() {
            super("player_has_tag", IResourceFactory.PropertyType.Condition);
        }

        @Override
        public IResourceProperty createObject(JsonObject obj) {
            return new PropPlayerHasTag(obj);
        }

        @Override
        public void addExample(JsonObject obj) {
            obj.addProperty("tagID", "customTag");
        }

        @Override
        public MapElement getDocumentation() {
            MapElement map = super.getDocumentation();
            map.addElement(new TextElement("tagID", "").setDescription("The TagID that should be checkt for"));
            map.setDescription("Allows to check if a Player has a Unique Stored. (Good for Per player Treasure)");
            return map;
        }
    }
}

