/*
 * Decompiled with CFR 0.152.
 */
package scavenge.player.blockConditions;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import scavenge.api.autodoc.IntElement;
import scavenge.api.autodoc.MapElement;
import scavenge.api.autodoc.OptionalArrayElement;
import scavenge.api.autodoc.TextElement;
import scavenge.api.block.IResourceCondition;
import scavenge.api.block.IResourceFactory;
import scavenge.api.block.IResourceProperty;
import scavenge.api.block.impl.BaseResourceFactory;
import scavenge.api.block.impl.BaseResourceProperty;
import scavenge.api.utils.CompatState;
import scavenge.api.utils.JsonUtil;
import scavenge.api.utils.LootUtil;
import scavenge.api.utils.StackObject;

public class PropPlayerHasItems
extends BaseResourceProperty
implements IResourceCondition {
    List<StackObject> list = new ArrayList<StackObject>();

    public PropPlayerHasItems(JsonObject obj) {
        super(obj, "player_has_items");
        this.addSelfIncompat();
        JsonUtil.convertToObject(obj.get("items"), new Consumer<JsonObject>(){

            @Override
            public void accept(JsonObject t) {
                StackObject obj = JsonUtil.createStackObject(t);
                if (obj == null) {
                    throw new RuntimeException("Object [" + t + "] caused a null Object this is not allowed");
                }
                PropPlayerHasItems.this.list.add(obj);
            }
        });
    }

    @Override
    public void addJEIData(IResourceProperty.IJEIBlockHandler collector) {
        collector.addExtraLayer("Player has to have Items");
        for (StackObject obj : this.list) {
            collector.addInfo(obj.getStackize() + "x " + obj.getName());
        }
        collector.finishLayer();
    }

    @Override
    public boolean canInteract(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean leftClick, EnumFacing side, String resourceID, boolean client) {
        ArrayList<StackObject> toCheck = new ArrayList<StackObject>(this.list.size());
        for (StackObject obj : this.list) {
            toCheck.add(obj);
        }
        InventoryPlayer inv = player.field_71071_by;
        this.checkInventory((NonNullList<ItemStack>)inv.field_70462_a, toCheck);
        this.checkInventory((NonNullList<ItemStack>)inv.field_70460_b, toCheck);
        this.checkInventory((NonNullList<ItemStack>)inv.field_184439_c, toCheck);
        return toCheck.isEmpty();
    }

    private void checkInventory(NonNullList<ItemStack> array, List<StackObject> stackList) {
        if (stackList.isEmpty()) {
            return;
        }
        for (int i = 0; i < array.size(); ++i) {
            ItemStack stack = (ItemStack)array.get(i);
            if (LootUtil.isStackEmpty(stack)) continue;
            int stackSize = LootUtil.getStackSize(stack);
            Iterator<StackObject> iter = stackList.iterator();
            while (iter.hasNext()) {
                StackObject obj = iter.next();
                if (!obj.matches(stack)) continue;
                if (obj.getStackize() <= stackSize) {
                    stackSize -= obj.getStackize();
                    iter.remove();
                } else {
                    obj.decreaseStackSize(stackSize);
                    stackSize = 0;
                }
                if (stackSize > 0) continue;
                break;
            }
            if (!stackList.isEmpty()) continue;
            return;
        }
    }

    public static class PlayerHasItemsFactory
    extends BaseResourceFactory {
        public PlayerHasItemsFactory() {
            super("player_has_items", IResourceFactory.PropertyType.Condition);
            this.setCompatState(CompatState.INCOMPATIBLE);
        }

        @Override
        public IResourceProperty createObject(JsonObject obj) {
            return new PropPlayerHasItems(obj);
        }

        @Override
        public void addExample(JsonObject obj) {
            JsonObject object = new JsonObject();
            object.addProperty("name", "minecraft:stick");
            object.addProperty("amount", (Number)32);
            JsonArray array = new JsonArray();
            array.add((JsonElement)object);
            obj.add("items", (JsonElement)array);
        }

        @Override
        public MapElement getDocumentation() {
            MapElement base = new MapElement("");
            base.addElement(new TextElement("name", "").setDescription("The Item that should be searched for"));
            base.addElement(new IntElement("meta", Short.MAX_VALUE, "The Metadata that should be searched for"));
            base.addElement(new IntElement("amount", 1, "The Stacksize that should be searched for"));
            base.addElement(new TextElement("nbt", "null", "The NBTData that should be checkt for. Defaults to ignore"));
            MapElement map = super.getDocumentation();
            map.addElement(new OptionalArrayElement("items", base));
            map.setDescription("Allows to Check for Items inside of the Players inventory");
            return map;
        }
    }
}

