/*
 * Decompiled with CFR 0.152.
 */
package scavenge.player.blockConditions;

import com.google.gson.JsonObject;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.Potion;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import scavenge.api.autodoc.BooleanElement;
import scavenge.api.autodoc.MapElement;
import scavenge.api.autodoc.TextElement;
import scavenge.api.block.IResourceCondition;
import scavenge.api.block.IResourceFactory;
import scavenge.api.block.IResourceProperty;
import scavenge.api.block.impl.BaseResourceFactory;
import scavenge.api.block.impl.BaseResourceProperty;
import scavenge.api.utils.JsonUtil;

public class PropHasPotion
extends BaseResourceProperty
implements IResourceCondition {
    Potion potion;
    boolean required;

    public PropHasPotion(JsonObject obj) {
        super(obj, "require_potion");
        this.potion = Potion.func_180142_b((String)obj.get("name").getAsString());
        this.required = JsonUtil.getOrDefault(obj, "required", true);
        if (this.required) {
            this.setJEIInfo("Player requires [" + I18n.func_74838_a((String)this.potion.func_76393_a()) + "] Potion Effect");
        } else {
            this.setJEIInfo("Player is not allowed to have [" + I18n.func_74838_a((String)this.potion.func_76393_a()) + "] Potion Effect");
        }
    }

    @Override
    public boolean canInteract(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean leftClick, EnumFacing side, String resourceID, boolean client) {
        return player.func_70644_a(this.potion) == this.required;
    }

    public static class HasPotionFactory
    extends BaseResourceFactory {
        public HasPotionFactory() {
            super("require_potion", IResourceFactory.PropertyType.Condition);
        }

        @Override
        public IResourceProperty createObject(JsonObject obj) {
            return new PropHasPotion(obj);
        }

        @Override
        public MapElement getDocumentation() {
            MapElement map = super.getDocumentation();
            map.addElement(new TextElement("name", "").setDescription("PotionRegistryName that should be checkt for"));
            map.addElement(new BooleanElement("required", true, "if the Potion is required or not"));
            map.setDescription("Allows to check for if the Player has a PotionEffect");
            return map;
        }

        @Override
        public void addExample(JsonObject obj) {
            obj.addProperty("name", "minecraft:weakness");
            obj.addProperty("required", Boolean.valueOf(true));
        }
    }
}

