/*
 * Decompiled with CFR 0.152.
 */
package scavenge.player.blockConditions;

import com.google.gson.JsonObject;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import scavenge.api.autodoc.BooleanElement;
import scavenge.api.autodoc.ChoiceElement;
import scavenge.api.autodoc.IntElement;
import scavenge.api.autodoc.MapElement;
import scavenge.api.block.IResourceCondition;
import scavenge.api.block.IResourceFactory;
import scavenge.api.block.IResourceProperty;
import scavenge.api.block.impl.BaseResourceFactory;
import scavenge.api.block.impl.BaseResourceProperty;
import scavenge.api.math.IMathOperation;
import scavenge.api.utils.CompatState;
import scavenge.api.utils.JsonUtil;
import scavenge.core.math.operation.BiggerOperation;
import scavenge.core.math.operation.SmallerOperation;

public class PropHasAir
extends BaseResourceProperty
implements IResourceCondition {
    IMathOperation operation;

    public PropHasAir(JsonObject obj) {
        super(obj, "require_air");
        if (obj.has("operations")) {
            this.operation = JsonUtil.getMathOperation("operations", obj);
            this.setJEIInfo(JsonUtil.getOrDefault(obj, "jeiDesc", ""));
        } else {
            int value = JsonUtil.getOrDefault(obj, "value", 0);
            if (JsonUtil.getOrDefault(obj, "bigger", true)) {
                this.operation = new BiggerOperation(value);
                this.setJEIInfo("Players Air Level is bigger then " + value);
            } else {
                this.operation = new SmallerOperation(value);
                this.setJEIInfo("Players Air Level is smaller then " + value);
            }
        }
    }

    @Override
    public boolean canInteract(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean leftClick, EnumFacing side, String resourceID, boolean client) {
        return this.operation.matches(player.func_70086_ai());
    }

    public static class HasAirFactory
    extends BaseResourceFactory {
        public HasAirFactory() {
            super("require_air", IResourceFactory.PropertyType.Condition);
            this.setCompatState(CompatState.PARTCOMPATIBLE);
        }

        @Override
        public IResourceProperty createObject(JsonObject obj) {
            return new PropHasAir(obj);
        }

        @Override
        public void addExample(JsonObject obj) {
            obj.addProperty("bigger", Boolean.valueOf(true));
            obj.addProperty("value", (Number)100);
        }

        @Override
        public MapElement getDocumentation() {
            MapElement map = super.getDocumentation();
            ChoiceElement choice = new ChoiceElement("", 2);
            choice.addElement(0, new BooleanElement("bigger", true, "If the Air should be bigger then the given value"));
            choice.addElement(0, new IntElement("value", 0, "how much air should be required or not"));
            this.addDefaultOperationText(choice, 1);
            map.addElement(choice);
            map.setDescription("Allows to check the players Air Level (between -20 and 300)");
            return map;
        }
    }
}

