/*
 * Decompiled with CFR 0.152.
 */
package scavenge.loot.effects;

import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import scavenge.api.autodoc.ArrayElement;
import scavenge.api.autodoc.ChoiceElement;
import scavenge.api.autodoc.IntElement;
import scavenge.api.autodoc.MapElement;
import scavenge.api.loot.ILootProperty;
import scavenge.api.loot.impl.BaseActiveLootProperty;
import scavenge.api.loot.impl.BaseLootFactory;
import scavenge.api.utils.JsonUtil;
import scavenge.api.utils.LootUtil;

public class PropSetRandomSize
extends BaseActiveLootProperty {
    List<Integer> list = new ArrayList<Integer>();

    public PropSetRandomSize(JsonObject obj) {
        super("set_random_size");
        if (obj.has("pool")) {
            JsonUtil.convertToPrimitive(obj.get("pool"), new Consumer<JsonPrimitive>(){

                @Override
                public void accept(JsonPrimitive t) {
                    PropSetRandomSize.this.list.add(t.getAsInt());
                }
            });
        } else {
            int min = obj.get("minValue").getAsInt();
            int max = obj.get("maxValue").getAsInt();
            int count = max - min;
            for (int i = 0; i <= count; ++i) {
                this.list.add(min + i);
            }
        }
    }

    @Override
    public ItemStack applyActiveEffect(ItemStack stack, NBTTagCompound customData) {
        LootUtil.setStackSize(stack, this.list.get(rand.nextInt(this.list.size())));
        return stack;
    }

    @Override
    public List<ItemStack> applyMultiInfoEffect(ItemStack stack) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        for (Integer entry : this.list) {
            ItemStack copy = stack.func_77946_l();
            LootUtil.setStackSize(copy, entry);
            result.add(copy);
        }
        return result;
    }

    public static class SetRandomSizeFactory
    extends BaseLootFactory {
        public SetRandomSizeFactory() {
            super("set_random_size", true);
        }

        @Override
        public ILootProperty createObject(JsonObject obj) {
            return new PropSetRandomSize(obj);
        }

        @Override
        public MapElement getDocumentation() {
            MapElement map = new MapElement("");
            map.setDescription("Allows to set a Random sized loot");
            ChoiceElement choice = new ChoiceElement("", 2);
            choice.addElement(0, new IntElement("minValue", 0).setDescription("Min Stacksize of the loot"));
            choice.addElement(0, new IntElement("maxValue", 0).setDescription("Max Stacksize of the loot"));
            choice.addElement(1, new ArrayElement("pool", new IntElement("", 0)).setDescription("A Pool of Random numbers to pick from"));
            map.addElement(choice);
            return map;
        }

        @Override
        public void addExample(JsonObject obj) {
            obj.addProperty("minValue", (Number)1);
            obj.addProperty("maxValue", (Number)32);
        }
    }
}

