/*
 * Decompiled with CFR 0.152.
 */
package scavenge.loot.effects;

import com.google.gson.JsonObject;
import net.minecraft.item.ItemStack;
import scavenge.api.autodoc.MapElement;
import scavenge.api.autodoc.TextElement;
import scavenge.api.loot.ILootProperty;
import scavenge.api.loot.impl.BaseLootFactory;
import scavenge.api.loot.impl.BasePassiveLootProperty;

public class PropSetName
extends BasePassiveLootProperty {
    String name;

    public PropSetName(JsonObject obj) {
        super("set_name");
        this.name = obj.get("name").getAsString();
    }

    @Override
    public ItemStack applyPassiveEffect(ItemStack stack) {
        stack.func_151001_c(this.name);
        return stack;
    }

    @Override
    public ItemStack applyInfoEffect(ItemStack stack) {
        stack.func_151001_c(this.name);
        return stack;
    }

    public static class SetNameFactory
    extends BaseLootFactory {
        public SetNameFactory() {
            super("set_name", false);
        }

        @Override
        public ILootProperty createObject(JsonObject obj) {
            return new PropSetName(obj);
        }

        @Override
        public MapElement getDocumentation() {
            MapElement map = new MapElement("");
            map.setDescription("Allows to set the name of the loot item");
            map.addElement(new TextElement("name", "").setDescription("The name of the item"));
            return map;
        }

        @Override
        public void addExample(JsonObject obj) {
            obj.addProperty("name", "Example Name!");
        }
    }
}

