/*
 * Decompiled with CFR 0.152.
 */
package scavenge.loot.effects;

import com.google.gson.JsonObject;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import scavenge.api.ScavengeAPI;
import scavenge.api.autodoc.MapElement;
import scavenge.api.autodoc.TextElement;
import scavenge.api.loot.ILootProperty;
import scavenge.api.loot.impl.BaseLootFactory;
import scavenge.api.loot.impl.BasePassiveLootProperty;
import scavenge.api.utils.JsonUtil;

public class PropSetNBTData
extends BasePassiveLootProperty {
    NBTTagCompound nbt;

    public PropSetNBTData(JsonObject obj) {
        super("set_nbtData");
        String id = JsonUtil.getOrDefault(obj, "name", "empty");
        this.nbt = id.equalsIgnoreCase("empty") ? null : ScavengeAPI.INSTANCE.getCompound(id);
    }

    @Override
    public ItemStack applyPassiveEffect(ItemStack stack) {
        stack.func_77982_d(this.nbt);
        return stack;
    }

    @Override
    public ItemStack applyInfoEffect(ItemStack stack) {
        stack.func_77982_d(this.nbt);
        return stack;
    }

    public static class SetNBTDataFactory
    extends BaseLootFactory {
        public SetNBTDataFactory() {
            super("set_nbtData", false);
        }

        @Override
        public ILootProperty createObject(JsonObject obj) {
            return new PropSetNBTData(obj);
        }

        @Override
        public MapElement getDocumentation() {
            MapElement map = new MapElement("");
            map.setDescription("Allows to set the Stacks NBTData");
            map.addElement(new TextElement("name", "empty", "The NBT File Reference for NBTData you want to add. empty = clearing"));
            return map;
        }

        @Override
        public void addExample(JsonObject obj) {
            obj.addProperty("name", "empty");
        }
    }
}

